/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.server;

import java.io.IOException;
import java.io.InputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.attribute.FileAttribute;
import org.uberfire.server.BaseFilteredServlet;

public abstract class BaseUploadServlet
extends BaseFilteredServlet {
    private static final Logger logger = LoggerFactory.getLogger(BaseUploadServlet.class);

    protected FileItem getFileItem(HttpServletRequest request) throws FileUploadException {
        for (FileItem item : this.getServletFileUpload().parseRequest(request)) {
            if (item.isFormField()) continue;
            return item;
        }
        return null;
    }

    protected void writeResponse(HttpServletResponse response, String ok) throws IOException {
        response.setContentType("text/html");
        response.getWriter().write(ok);
        response.getWriter().flush();
    }

    protected ServletFileUpload getServletFileUpload() {
        DiskFileItemFactory factory = new DiskFileItemFactory();
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
        upload.setHeaderEncoding("UTF-8");
        return upload;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeFile(IOService ioService, Path path, FileItem uploadedItem) throws IOException {
        try {
            ioService.startBatch(path.getFileSystem());
            if (!ioService.exists(path)) {
                ioService.createFile(path, new FileAttribute[0]);
            }
            ioService.write(path, IOUtils.toByteArray((InputStream)uploadedItem.getInputStream()), new OpenOption[0]);
        }
        finally {
            uploadedItem.getInputStream().close();
            ioService.endBatch();
        }
    }

    protected void logError(Throwable e) {
        logger.error("Failed to upload a file.", e);
    }
}

