/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.management.wildfly8.cli;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.RealmCallback;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.dmr.ModelNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Wildfly8ModelUtil {
    private static final Logger LOG = LoggerFactory.getLogger(Wildfly8ModelUtil.class);

    public static ModelControllerClient getClient(String host, int port, final String adminUser, final String adminPassword) throws Exception {
        return ModelControllerClient.Factory.create((InetAddress)InetAddress.getByName(host), (int)port, (CallbackHandler)new CallbackHandler(){

            @Override
            public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                for (Callback current : callbacks) {
                    if (current instanceof NameCallback) {
                        NameCallback ncb = (NameCallback)current;
                        ncb.setName(adminUser);
                        continue;
                    }
                    if (current instanceof PasswordCallback) {
                        PasswordCallback pcb = (PasswordCallback)current;
                        pcb.setPassword(adminPassword.toCharArray());
                        continue;
                    }
                    if (current instanceof RealmCallback) {
                        RealmCallback rcb = (RealmCallback)current;
                        rcb.setText(rcb.getDefaultText());
                        continue;
                    }
                    throw new UnsupportedCallbackException(current);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getPropertiesFilePath(String context, String realm, ModelControllerClient client) throws Exception {
        String result = null;
        if (client != null) {
            ModelNode operation = new ModelNode();
            operation.get("operation").set("read-resource");
            ModelNode address = operation.get("address");
            address.add("core-service", "management");
            address.add("security-realm", realm);
            address.add(context, "properties");
            try {
                ModelNode resultNode;
                ModelNode returnVal = client.execute(operation);
                if ("success".equalsIgnoreCase(returnVal.get("outcome").asString()) && (resultNode = returnVal.get("result")) != null) {
                    String path = resultNode.get("path").asString();
                    String relativeTo = resultNode.get("relative-to").asString();
                    String relativeToPath = System.getProperty(relativeTo);
                    String string = new File(relativeToPath, path).getAbsolutePath();
                    return string;
                }
            }
            catch (Exception e) {
                LOG.error("Error reading realm using CLI commands.", (Throwable)e);
            }
            finally {
                client.close();
            }
        }
        return result;
    }
}

