/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.management.client;

import java.util.Collection;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.errai.bus.client.api.messaging.Message;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jboss.errai.security.shared.api.Group;
import org.jboss.errai.security.shared.api.GroupImpl;
import org.jboss.errai.security.shared.api.Role;
import org.jboss.errai.security.shared.api.RoleImpl;
import org.jboss.errai.security.shared.api.identity.User;
import org.jboss.errai.security.shared.api.identity.UserImpl;
import org.uberfire.client.workbench.widgets.common.ErrorPopupPresenter;
import org.uberfire.ext.security.management.api.Capability;
import org.uberfire.ext.security.management.api.CapabilityStatus;
import org.uberfire.ext.security.management.api.GroupManager;
import org.uberfire.ext.security.management.api.GroupManagerSettings;
import org.uberfire.ext.security.management.api.RoleManager;
import org.uberfire.ext.security.management.api.UserManager;
import org.uberfire.ext.security.management.api.UserManagerSettings;
import org.uberfire.ext.security.management.api.UserSystemManager;
import org.uberfire.ext.security.management.api.service.GroupManagerService;
import org.uberfire.ext.security.management.api.service.RoleManagerService;
import org.uberfire.ext.security.management.api.service.UserManagerService;
import org.uberfire.ext.security.management.api.validation.EntityValidator;
import org.uberfire.ext.security.management.client.ClientSecurityExceptionMessageResolver;
import org.uberfire.ext.security.management.client.validation.ClientGroupValidator;
import org.uberfire.ext.security.management.client.validation.ClientRoleValidator;
import org.uberfire.ext.security.management.client.validation.ClientUserValidator;
import org.uberfire.ext.security.management.impl.UserAttributeImpl;
import org.uberfire.mvp.Command;

@ApplicationScoped
public class ClientUserSystemManager
implements UserSystemManager {
    UserManagerSettings userManagerSettings;
    GroupManagerSettings groupManagerSettings;
    ErrorPopupPresenter errorPopupPresenter;
    private final Caller<UserManagerService> usersManagerService;
    private final Caller<GroupManagerService> groupsManagerService;
    private final Caller<RoleManagerService> rolesManagerService;
    private final ClientSecurityExceptionMessageResolver exceptionMessageResolver;
    private boolean isActive;
    protected final ErrorCallback<Message> loadErrorCallback = new ErrorCallback<Message>(){

        public boolean error(Message message, Throwable throwable) {
            ClientUserSystemManager.this.showError(throwable);
            ClientUserSystemManager.this.isActive = false;
            return false;
        }
    };

    @Inject
    public ClientUserSystemManager(Caller<UserManagerService> usersManagerService, Caller<GroupManagerService> groupsManagerService, Caller<RoleManagerService> rolesManagerService, ClientSecurityExceptionMessageResolver exceptionMessageResolver, ErrorPopupPresenter errorPopupPresenter) {
        this.usersManagerService = usersManagerService;
        this.groupsManagerService = groupsManagerService;
        this.rolesManagerService = rolesManagerService;
        this.exceptionMessageResolver = exceptionMessageResolver;
        this.errorPopupPresenter = errorPopupPresenter;
        this.isActive = false;
    }

    @PostConstruct
    public void initCache() {
        this.initializeCache(() -> {
            this.isActive = true;
        }, this.loadErrorCallback);
    }

    public UserManager users(RemoteCallback<?> remoteCallback, ErrorCallback errorCallback) {
        return (UserManager)this.usersManagerService.call(remoteCallback, errorCallback);
    }

    public GroupManager groups(RemoteCallback<?> remoteCallback, ErrorCallback errorCallback) {
        return (GroupManager)this.groupsManagerService.call(remoteCallback, errorCallback);
    }

    public RoleManager roles(RemoteCallback<?> remoteCallback, ErrorCallback errorCallback) {
        return (RoleManager)this.rolesManagerService.call(remoteCallback, errorCallback);
    }

    public UserManager users() {
        return (UserManager)this.usersManagerService.call();
    }

    public GroupManager groups() {
        return (GroupManager)this.groupsManagerService.call();
    }

    public RoleManager roles() {
        return (RoleManager)this.rolesManagerService.call();
    }

    public boolean isUserCapabilityEnabled(Capability capability) {
        if (this.userManagerSettings != null) {
            return this.isCapabilityEnabled(this.userManagerSettings.getCapabilities(), capability);
        }
        return false;
    }

    public Collection<UserManager.UserAttribute> getUserSupportedAttributes() {
        return this.userManagerSettings.getSupportedAttributes();
    }

    public UserManager.UserAttribute getUserSupportedAttribute(String attributeName) {
        if (attributeName != null && this.userManagerSettings != null && this.userManagerSettings.getSupportedAttributes() != null) {
            for (UserManager.UserAttribute attribute : this.userManagerSettings.getSupportedAttributes()) {
                if (!attributeName.equals(attribute.getName())) continue;
                return attribute;
            }
        }
        return null;
    }

    public boolean isGroupCapabilityEnabled(Capability capability) {
        if (this.groupManagerSettings != null) {
            return this.isCapabilityEnabled(this.groupManagerSettings.getCapabilities(), capability);
        }
        return false;
    }

    public boolean isCapabilityEnabled(Map<Capability, CapabilityStatus> capabilities, Capability capability) {
        if (capabilities != null) {
            CapabilityStatus status = capabilities.get(capability);
            return status != null && CapabilityStatus.ENABLED.equals((Object)status);
        }
        return false;
    }

    public Collection<String> getConstrainedGroups() {
        return this.groupManagerSettings != null ? this.groupManagerSettings.getConstrainedGroups() : null;
    }

    public User createUser(String identifier) {
        if (identifier == null) {
            return null;
        }
        return new UserImpl(identifier);
    }

    public UserManager.UserAttribute createUserAttribute(String name, boolean isMandatory, boolean isEditable, String defaultValue) {
        if (name == null) {
            return null;
        }
        return new UserAttributeImpl(name, isMandatory, isEditable, defaultValue);
    }

    public Group createGroup(String name) {
        if (name == null) {
            return null;
        }
        return new GroupImpl(name);
    }

    public Role createRole(String name) {
        if (name == null) {
            return null;
        }
        return new RoleImpl(name);
    }

    public EntityValidator<User> usersValidator() {
        return new ClientUserValidator();
    }

    public EntityValidator<Group> groupsValidator() {
        return new ClientGroupValidator();
    }

    public EntityValidator<Role> rolesValidator() {
        return new ClientRoleValidator();
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void waitForInitialization(Command command) {
        if (null != command) {
            this.initializeCache(command, (ErrorCallback<Message>)((ErrorCallback)(message, throwable) -> {
                command.execute();
                return false;
            }));
        }
    }

    public UserManagerSettings getUserManagerSettings() {
        return this.userManagerSettings;
    }

    public GroupManagerSettings getGroupManagerSettings() {
        return this.groupManagerSettings;
    }

    private void initializeCache(final Command command, ErrorCallback<Message> errorCallback) {
        this.loadUserSettings(() -> this.loadGroupSettings(new Command(){

            public void execute() {
                command.execute();
            }
        }, errorCallback), errorCallback);
    }

    private void loadUserSettings(final Command callback, ErrorCallback<Message> errorCallback) {
        if (null == this.userManagerSettings) {
            ((UserManagerService)this.usersManagerService.call((RemoteCallback)new RemoteCallback<UserManagerSettings>(){

                public void callback(UserManagerSettings userManagerSettings) {
                    ClientUserSystemManager.this.userManagerSettings = userManagerSettings;
                    if (null != callback) {
                        callback.execute();
                    }
                }
            }, errorCallback)).getSettings();
        } else {
            callback.execute();
        }
    }

    private void loadGroupSettings(final Command callback, ErrorCallback<Message> errorCallback) {
        if (null == this.groupManagerSettings) {
            ((GroupManagerService)this.groupsManagerService.call((RemoteCallback)new RemoteCallback<GroupManagerSettings>(){

                public void callback(GroupManagerSettings groupManagerSettings) {
                    ClientUserSystemManager.this.groupManagerSettings = groupManagerSettings;
                    if (null != callback) {
                        callback.execute();
                    }
                }
            }, errorCallback)).getSettings();
        } else {
            callback.execute();
        }
    }

    void showError(Throwable throwable) {
        this.exceptionMessageResolver.consumeExceptionMessage(throwable, arg_0 -> ((ErrorPopupPresenter)this.errorPopupPresenter).showMessage(arg_0));
    }
}

