/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.project.client.preferences;

import org.guvnor.common.services.project.client.preferences.SpaceScopedResolutionStrategySupplier;
import org.guvnor.common.services.project.context.WorkspaceProjectContextChangeEvent;
import org.guvnor.common.services.shared.preferences.WorkbenchPreferenceScopeResolutionStrategies;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.preferences.shared.impl.PreferenceScopeResolutionStrategyInfo;

@RunWith(value=MockitoJUnitRunner.class)
public class SpaceScopedResolutionStrategySupplierTest {
    private SpaceScopedResolutionStrategySupplier strategySupplier;
    @Mock
    private WorkbenchPreferenceScopeResolutionStrategies scopeResolutionStrategies;

    @Before
    public void setup() {
        this.strategySupplier = (SpaceScopedResolutionStrategySupplier)Mockito.spy((Object)new SpaceScopedResolutionStrategySupplier(this.scopeResolutionStrategies));
    }

    @Test
    public void getWithoutOrganizationalUnitTest() {
        PreferenceScopeResolutionStrategyInfo strategyInfo = this.strategySupplier.get();
        ((WorkbenchPreferenceScopeResolutionStrategies)Mockito.verify((Object)this.scopeResolutionStrategies)).getSpaceInfoFor(null);
    }

    @Test
    public void getWithOrganizationalUnitTest() {
        OrganizationalUnit organizationalUnit = (OrganizationalUnit)Mockito.mock(OrganizationalUnit.class);
        ((OrganizationalUnit)Mockito.doReturn((Object)"identifier").when((Object)organizationalUnit)).getIdentifier();
        WorkspaceProjectContextChangeEvent event = (WorkspaceProjectContextChangeEvent)Mockito.mock(WorkspaceProjectContextChangeEvent.class);
        ((WorkspaceProjectContextChangeEvent)Mockito.doReturn((Object)organizationalUnit).when((Object)event)).getOrganizationalUnit();
        this.strategySupplier.onWorkspaceProjectContextChangeEvent(event);
        PreferenceScopeResolutionStrategyInfo strategyInfo = this.strategySupplier.get();
        ((WorkbenchPreferenceScopeResolutionStrategies)Mockito.verify((Object)this.scopeResolutionStrategies)).getSpaceInfoFor("identifier");
    }
}

