/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.preferences.client.admin;

import java.util.Collections;
import java.util.Map;
import java.util.function.Consumer;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.uberfire.client.annotations.Perspective;
import org.uberfire.client.annotations.WorkbenchMenu;
import org.uberfire.client.annotations.WorkbenchPerspective;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.workbench.panels.impl.StaticWorkbenchPanelPresenter;
import org.uberfire.lifecycle.OnStartup;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;
import org.uberfire.workbench.model.PartDefinition;
import org.uberfire.workbench.model.PerspectiveDefinition;
import org.uberfire.workbench.model.impl.PartDefinitionImpl;
import org.uberfire.workbench.model.impl.PerspectiveDefinitionImpl;
import org.uberfire.workbench.model.menu.MenuFactory;
import org.uberfire.workbench.model.menu.Menus;

@ApplicationScoped
@WorkbenchPerspective(identifier="AdminPagePerspective")
public class AdminPagePerspective {
    public static final String IDENTIFIER = "AdminPagePerspective";
    @Inject
    private TranslationService translationService;
    @Inject
    private PlaceManager placeManager;
    private PerspectiveDefinition perspective;
    private String perspectiveIdentifierToGoBackTo = null;

    @Perspective
    public PerspectiveDefinition getPerspective() {
        if (this.perspective == null) {
            this.perspective = this.createPerspectiveDefinition();
            this.configurePerspective(Collections.emptyMap());
        }
        return this.perspective;
    }

    @OnStartup
    public void onStartup(PlaceRequest placeRequest) {
        this.perspectiveIdentifierToGoBackTo = placeRequest.getParameter("perspectiveIdentifierToGoBackTo", null);
        this.perspective = this.createPerspectiveDefinition();
        this.configurePerspective(placeRequest.getParameters());
    }

    PerspectiveDefinition createPerspectiveDefinition() {
        PerspectiveDefinitionImpl perspective = new PerspectiveDefinitionImpl(StaticWorkbenchPanelPresenter.class.getName());
        perspective.setName("Admin");
        return perspective;
    }

    void configurePerspective(Map<String, String> parameters) {
        this.perspective.getRoot().addPart((PartDefinition)new PartDefinitionImpl((PlaceRequest)new DefaultPlaceRequest("AdminPagePresenter", parameters)));
    }

    @WorkbenchMenu
    public void getMenus(Consumer<Menus> menusConsumer) {
        if (this.perspectiveIdentifierToGoBackTo != null) {
            menusConsumer.accept(((MenuFactory.TopLevelMenusBuilder)((MenuFactory.MenuBuilder)MenuFactory.newTopLevelMenu((String)this.translationService.format("AdminPagePerspective.GoBackToThePreviousPage", new Object[0])).respondsWith(() -> this.placeManager.goTo(this.perspectiveIdentifierToGoBackTo))).endMenu()).build());
        }
        menusConsumer.accept(null);
    }
}

