/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.preferences.client.admin.item;

import com.google.gwt.dom.client.Element;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.user.client.DOM;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.common.client.dom.Paragraph;
import org.jboss.errai.ui.client.local.api.IsElement;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.uberfire.ext.preferences.client.admin.item.AdminPageItemPresenter;
import org.uberfire.ext.preferences.client.admin.page.AdminTool;
import org.uberfire.mvp.ParameterizedCommand;

@Dependent
@Templated
public class AdminPageItemView
implements IsElement,
AdminPageItemPresenter.View {
    private final TranslationService translationService;
    @Inject
    @DataField(value="item")
    Div item;
    @DataField(value="item-icon")
    Element icon = DOM.createElement((String)"i");
    @Inject
    @DataField(value="item-text")
    Div text;
    @Inject
    @DataField(value="item-counter-container")
    Div counterContainer;
    @Inject
    @DataField(value="item-counter")
    Paragraph counterText;
    private AdminPageItemPresenter presenter;

    @Inject
    public AdminPageItemView(TranslationService translationService) {
        this.translationService = translationService;
    }

    public void init(AdminPageItemPresenter presenter) {
        this.presenter = presenter;
        AdminTool adminTool = presenter.getAdminTool();
        if (adminTool.getIconCss() != null) {
            adminTool.getIconCss().forEach(css -> this.icon.addClassName(css));
        }
        this.text.setTextContent(adminTool.getTitle());
        if (adminTool.hasCounter()) {
            adminTool.fetchCounter((ParameterizedCommand<Integer>)((ParameterizedCommand)counter -> this.counterText.setTextContent(String.valueOf(counter))));
        } else {
            this.counterContainer.setHidden(true);
        }
    }

    @EventHandler(value={"item"})
    public void enter(ClickEvent event) {
        this.presenter.enter();
    }
}

