/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.preferences.client.central.tree;

import com.google.gwt.dom.client.Element;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.user.client.DOM;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.ui.client.local.api.IsElement;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.uberfire.ext.preferences.client.central.tree.TreeHierarchyLeafItemPresenter;

@Dependent
@Templated
public class TreeHierarchyLeafItemView
implements IsElement,
TreeHierarchyLeafItemPresenter.View {
    @Inject
    @DataField(value="preference-tree-leaf-item-node")
    Div treeNode;
    @DataField(value="preference-tree-leaf-item-label")
    Element label = DOM.createLabel();
    private TreeHierarchyLeafItemPresenter presenter;
    @Inject
    private TranslationService translationService;

    public void init(TreeHierarchyLeafItemPresenter presenter) {
        this.presenter = presenter;
        this.treeNode.getStyle().setProperty("padding-left", presenter.getLevel() * 27 + 24 + "px");
        String preferenceLabel = this.getPreferenceLabel(presenter.getHierarchyElement().getBundleKey());
        this.label.setInnerHTML(preferenceLabel);
    }

    private String getPreferenceLabel(String bundleKey) {
        return this.translationService.format(bundleKey, new Object[0]);
    }

    @Override
    public void deselect() {
        this.treeNode.getClassList().remove("selected");
    }

    @EventHandler(value={"preference-tree-leaf-item-label"})
    public void select(ClickEvent event) {
        this.select();
    }

    @Override
    public void select() {
        if (!this.label.hasClassName("selected")) {
            this.presenter.select();
        }
    }

    @Override
    public void selectElement() {
        this.treeNode.getClassList().add("selected");
    }
}

