/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.m2repo.client.editor;

import com.google.gwt.cell.client.Cell;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.RequiresResize;
import com.google.gwt.user.client.ui.Widget;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.guvnor.m2repo.client.resources.i18n.M2RepoEditorConstants;
import org.guvnor.m2repo.client.widgets.ArtifactListPresenter;
import org.guvnor.m2repo.client.widgets.ColumnType;
import org.guvnor.m2repo.model.JarListPageRow;
import org.gwtbootstrap3.client.ui.constants.ButtonSize;
import org.gwtbootstrap3.client.ui.gwt.ButtonCell;
import org.gwtbootstrap3.client.ui.html.Div;
import org.jboss.errai.security.shared.api.identity.User;
import org.uberfire.security.authz.AuthorizationManager;

@Dependent
public class MavenRepositoryPagedJarTable
extends Composite
implements RequiresResize {
    private ArtifactListPresenter presenter;
    private AuthorizationManager authorizationManager;
    protected User identity;
    private final Div content = new Div();

    public MavenRepositoryPagedJarTable() {
    }

    @Inject
    public MavenRepositoryPagedJarTable(ArtifactListPresenter presenter, AuthorizationManager authorizationManager, User identity) {
        this.presenter = presenter;
        this.authorizationManager = authorizationManager;
        this.identity = identity;
        this.initWidget((Widget)this.content);
    }

    @PostConstruct
    public void init() {
        this.presenter.setup(ColumnType.NAME, ColumnType.GAV, ColumnType.LAST_MODIFIED);
        this.addViewPOMButton();
        if (this.authorizationManager.authorize("jar.download", this.identity)) {
            this.addDownloadJARButton();
        }
        this.presenter.search("");
        this.content.add((IsWidget)this.presenter.getView());
    }

    public void onResize() {
        if (this.getParent().getOffsetHeight() - 148 > 0 && this.presenter != null) {
            this.presenter.getView().setContentHeight(this.getParent().getOffsetHeight() - 148 + "px");
        }
    }

    private String getFileDownloadURL(String path) {
        return this.getGuvnorM2RepoBaseURL() + path;
    }

    private String getGuvnorM2RepoBaseURL() {
        String baseUrl = GWT.getModuleBaseURL().replace(GWT.getModuleName() + "/", "");
        return baseUrl + "maven2/";
    }

    public void search(String filter) {
        this.presenter.search(filter);
    }

    public void refresh() {
        this.presenter.refresh();
    }

    void addViewPOMButton() {
        Column<JarListPageRow, String> openColumn = new Column<JarListPageRow, String>((Cell)new ButtonCell(ButtonSize.EXTRA_SMALL)){

            public String getValue(JarListPageRow row) {
                return M2RepoEditorConstants.INSTANCE.Open();
            }
        };
        openColumn.setFieldUpdater((index, row, value) -> this.presenter.onOpenPom(row.getPath()));
        this.presenter.getView().addColumn(openColumn, M2RepoEditorConstants.INSTANCE.Open(), 100.0, Style.Unit.PX);
    }

    void addDownloadJARButton() {
        Column<JarListPageRow, String> downloadColumn = new Column<JarListPageRow, String>((Cell)new ButtonCell(ButtonSize.EXTRA_SMALL)){

            public String getValue(JarListPageRow row) {
                return M2RepoEditorConstants.INSTANCE.Download();
            }
        };
        downloadColumn.setFieldUpdater((index, row, value) -> Window.open((String)this.getFileDownloadURL(row.getPath()), (String)M2RepoEditorConstants.INSTANCE.Downloading(), (String)"resizable=no,scrollbars=yes,status=no"));
        this.presenter.getView().addColumn(downloadColumn, M2RepoEditorConstants.INSTANCE.Download(), 100.0, Style.Unit.PX);
    }
}

