/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.m2repo.utils;

public class FileNameUtilities {
    private FileNameUtilities() {
    }

    public static boolean isValid(String fileName) {
        return FileNameUtilities.isJar(fileName) || FileNameUtilities.isKJar(fileName) || FileNameUtilities.isPom(fileName);
    }

    public static boolean isJar(String fileName) {
        return FileNameUtilities.endsWith(fileName, ".jar");
    }

    public static boolean isKJar(String fileName) {
        return FileNameUtilities.endsWith(fileName, ".kjar");
    }

    public static boolean isPom(String fileName) {
        return FileNameUtilities.endsWith(fileName, "pom.xml");
    }

    public static boolean isDeployedPom(String path) {
        return FileNameUtilities.endsWith(path, ".pom");
    }

    private static boolean endsWith(String path, String suffix) {
        return path != null && !path.trim().isEmpty() && path.toLowerCase().endsWith(suffix);
    }
}

