/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.server.io;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import javax.inject.Named;
import org.uberfire.backend.repositories.Repository;
import org.uberfire.backend.server.io.IOSecurityAuth;
import org.uberfire.backend.server.io.IOSecurityAuthz;
import org.uberfire.backend.server.repositories.RepositoryServiceImpl;
import org.uberfire.backend.server.repositories.SystemRepository;
import org.uberfire.backend.server.security.RepositoryAuthorizationManager;
import org.uberfire.commons.async.SimpleAsyncExecutorService;
import org.uberfire.commons.cluster.ClusterServiceFactory;
import org.uberfire.io.IOService;
import org.uberfire.io.impl.IOServiceNio2WrapperImpl;
import org.uberfire.io.impl.cluster.IOServiceClusterImpl;
import org.uberfire.security.auth.AuthenticationManager;
import org.uberfire.security.auth.RolesMode;
import org.uberfire.security.authz.AuthorizationManager;
import org.uberfire.security.server.auth.impl.JAASAuthenticationManager;
import org.uberfire.security.server.auth.impl.PropertyAuthenticationManager;

@ApplicationScoped
public class ConfigIOServiceProducer {
    @Inject
    private RepositoryServiceImpl repositoryService;
    @Inject
    @Named(value="clusterServiceFactory")
    private ClusterServiceFactory clusterServiceFactory;
    private IOService configIOService;
    private AuthorizationManager authorizationManager;
    private AuthenticationManager authenticationManager;

    @PostConstruct
    public void init() {
        RolesMode mode;
        String authType = System.getProperty("org.uberfire.io.auth", null);
        String domain = System.getProperty("org.uberfire.domain", null);
        String _mode = System.getProperty("org.uberfire.roles.mode", RolesMode.GROUP.toString());
        try {
            mode = RolesMode.valueOf((String)_mode);
        }
        catch (Exception ignore) {
            mode = RolesMode.GROUP;
        }
        this.authenticationManager = authType == null || authType.toLowerCase().equals("jaas") || authType.toLowerCase().equals("container") ? new JAASAuthenticationManager(domain, mode) : (authType.toLowerCase().equals("property") ? new PropertyAuthenticationManager(null) : this.loadClazz(authType, AuthenticationManager.class));
        this.setup();
    }

    private <T> T loadClazz(String clazzName, Class<T> typeOf) {
        if (clazzName == null || clazzName.isEmpty()) {
            return null;
        }
        try {
            Class<?> clazz = Class.forName(clazzName);
            if (!typeOf.isAssignableFrom(clazz)) {
                return null;
            }
            return typeOf.cast(clazz.newInstance());
        }
        catch (ClassNotFoundException ignored) {
        }
        catch (InstantiationException ignored) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return null;
    }

    public void setup() {
        this.configIOService = this.clusterServiceFactory == null ? new IOServiceNio2WrapperImpl("config") : new IOServiceClusterImpl((IOService)new IOServiceNio2WrapperImpl("config"), this.clusterServiceFactory, this.clusterServiceFactory.isAutoStart());
        this.authorizationManager = new RepositoryAuthorizationManager(this.repositoryService);
        this.configIOService.setAuthenticationManager(this.authenticationManager);
        this.configIOService.setAuthorizationManager(this.authorizationManager);
    }

    @PreDestroy
    public void onShutdown() {
        this.configIOService.dispose();
        SimpleAsyncExecutorService.shutdownInstances();
    }

    @Produces
    @Named(value="configIO")
    public IOService configIOService() {
        return this.configIOService;
    }

    @Produces
    @Named(value="system")
    public Repository systemRepository() {
        return SystemRepository.SYSTEM_REPO;
    }

    @Produces
    @IOSecurityAuthz
    public AuthorizationManager authorizationManager() {
        return this.authorizationManager;
    }

    @Produces
    @IOSecurityAuth
    public AuthenticationManager authenticationManager() {
        return this.authenticationManager;
    }
}

