/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.server.organizationalunit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.errai.bus.server.annotations.Service;
import org.uberfire.backend.organizationalunit.OrganizationalUnit;
import org.uberfire.backend.organizationalunit.OrganizationalUnitService;
import org.uberfire.backend.repositories.Repository;
import org.uberfire.backend.server.config.ConfigGroup;
import org.uberfire.backend.server.config.ConfigItem;
import org.uberfire.backend.server.config.ConfigType;
import org.uberfire.backend.server.config.ConfigurationFactory;
import org.uberfire.backend.server.config.ConfigurationService;
import org.uberfire.backend.server.organizationalunit.OrganizationalUnitFactory;

@Service
@ApplicationScoped
public class OrganizationalUnitServiceImpl
implements OrganizationalUnitService {
    @Inject
    private ConfigurationService configurationService;
    @Inject
    private ConfigurationFactory configurationFactory;
    @Inject
    private OrganizationalUnitFactory organizationalUnitFactory;
    private Map<String, OrganizationalUnit> registeredOrganizationalUnits = new HashMap<String, OrganizationalUnit>();

    @PostConstruct
    public void loadOrganizationalUnits() {
        List groups = this.configurationService.getConfiguration(ConfigType.ORGANIZATIONAL_UNIT);
        if (groups != null) {
            for (ConfigGroup groupConfig : groups) {
                OrganizationalUnit ou = this.organizationalUnitFactory.newOrganizationalUnit(groupConfig);
                this.registeredOrganizationalUnits.put(ou.getName(), ou);
            }
        }
    }

    public OrganizationalUnit getOrganizationalUnit(String name) {
        return this.registeredOrganizationalUnits.get(name);
    }

    public Collection<OrganizationalUnit> getOrganizationalUnits() {
        return new ArrayList<OrganizationalUnit>(this.registeredOrganizationalUnits.values());
    }

    public OrganizationalUnit createOrganizationalUnit(String name, String owner) {
        ConfigGroup groupConfig = this.configurationFactory.newConfigGroup(ConfigType.ORGANIZATIONAL_UNIT, name, "");
        groupConfig.addConfigItem(this.configurationFactory.newConfigItem("owner", owner));
        groupConfig.addConfigItem(this.configurationFactory.newConfigItem("repositories", new ArrayList()));
        groupConfig.addConfigItem(this.configurationFactory.newConfigItem("security:roles", new ArrayList()));
        this.configurationService.addConfiguration(groupConfig);
        OrganizationalUnit newOrganizationalUnit = this.organizationalUnitFactory.newOrganizationalUnit(groupConfig);
        this.registeredOrganizationalUnits.put(newOrganizationalUnit.getName(), newOrganizationalUnit);
        return newOrganizationalUnit;
    }

    public OrganizationalUnit createOrganizationalUnit(String name, String owner, Collection<Repository> repositories) {
        ConfigGroup groupConfig = this.configurationFactory.newConfigGroup(ConfigType.ORGANIZATIONAL_UNIT, name, "");
        groupConfig.addConfigItem(this.configurationFactory.newConfigItem("owner", owner));
        groupConfig.addConfigItem(this.configurationFactory.newConfigItem("repositories", this.getRepositoryAliases(repositories)));
        groupConfig.addConfigItem(this.configurationFactory.newConfigItem("security:roles", new ArrayList()));
        this.configurationService.addConfiguration(groupConfig);
        OrganizationalUnit newOrganizationalUnit = this.organizationalUnitFactory.newOrganizationalUnit(groupConfig);
        this.registeredOrganizationalUnits.put(newOrganizationalUnit.getName(), newOrganizationalUnit);
        return newOrganizationalUnit;
    }

    private List<String> getRepositoryAliases(Collection<Repository> repositories) {
        ArrayList<String> repositoryList = new ArrayList<String>();
        for (Repository repo : repositories) {
            repositoryList.add(repo.getAlias());
        }
        return repositoryList;
    }

    public void addRepository(OrganizationalUnit organizationalUnit, Repository repository) {
        ConfigGroup thisGroupConfig = this.findGroupConfig(organizationalUnit.getName());
        if (thisGroupConfig == null) {
            throw new IllegalArgumentException("OrganizationalUnit " + organizationalUnit.getName() + " not found");
        }
        ConfigItem repositories = thisGroupConfig.getConfigItem("repositories");
        ((List)repositories.getValue()).add(repository.getAlias());
        this.configurationService.updateConfiguration(thisGroupConfig);
        OrganizationalUnit updatedOrganizationalUnit = this.organizationalUnitFactory.newOrganizationalUnit(thisGroupConfig);
        this.registeredOrganizationalUnits.put(updatedOrganizationalUnit.getName(), updatedOrganizationalUnit);
    }

    public void removeRepository(OrganizationalUnit organizationalUnit, Repository repository) {
        ConfigGroup thisGroupConfig = this.findGroupConfig(organizationalUnit.getName());
        if (thisGroupConfig == null) {
            throw new IllegalArgumentException("OrganizationalUnit " + organizationalUnit.getName() + " not found");
        }
        ConfigItem repositories = thisGroupConfig.getConfigItem("repositories");
        ((List)repositories.getValue()).remove(repository.getAlias());
        this.configurationService.updateConfiguration(thisGroupConfig);
        OrganizationalUnit updatedOrganizationalUnit = this.organizationalUnitFactory.newOrganizationalUnit(thisGroupConfig);
        this.registeredOrganizationalUnits.put(updatedOrganizationalUnit.getName(), updatedOrganizationalUnit);
    }

    public void addRole(OrganizationalUnit organizationalUnit, String role) {
        ConfigGroup thisGroupConfig = this.findGroupConfig(organizationalUnit.getName());
        if (thisGroupConfig == null) {
            throw new IllegalArgumentException("OrganizationalUnit " + organizationalUnit.getName() + " not found");
        }
        ConfigItem roles = thisGroupConfig.getConfigItem("security:roles");
        ((List)roles.getValue()).add(role);
        this.configurationService.updateConfiguration(thisGroupConfig);
        OrganizationalUnit updatedOrganizationalUnit = this.organizationalUnitFactory.newOrganizationalUnit(thisGroupConfig);
        this.registeredOrganizationalUnits.put(updatedOrganizationalUnit.getName(), updatedOrganizationalUnit);
    }

    public void removeRole(OrganizationalUnit organizationalUnit, String role) {
        ConfigGroup thisGroupConfig = this.findGroupConfig(organizationalUnit.getName());
        if (thisGroupConfig == null) {
            throw new IllegalArgumentException("OrganizationalUnit " + organizationalUnit.getName() + " not found");
        }
        ConfigItem roles = thisGroupConfig.getConfigItem("security:roles");
        ((List)roles.getValue()).remove(role);
        this.configurationService.updateConfiguration(thisGroupConfig);
        OrganizationalUnit updatedOrganizationalUnit = this.organizationalUnitFactory.newOrganizationalUnit(thisGroupConfig);
        this.registeredOrganizationalUnits.put(updatedOrganizationalUnit.getName(), updatedOrganizationalUnit);
    }

    protected ConfigGroup findGroupConfig(String name) {
        List groups = this.configurationService.getConfiguration(ConfigType.ORGANIZATIONAL_UNIT);
        if (groups != null) {
            for (ConfigGroup groupConfig : groups) {
                if (!groupConfig.getName().equals(name)) continue;
                return groupConfig;
            }
        }
        return null;
    }

    public void removeOrganizationalUnit(String groupName) {
        ConfigGroup thisGroupConfig = this.findGroupConfig(groupName);
        if (thisGroupConfig != null) {
            this.configurationService.removeConfiguration(thisGroupConfig);
            this.registeredOrganizationalUnits.remove(groupName);
        }
    }
}

