/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.server.repositories.git;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.kie.commons.validation.Preconditions;
import org.uberfire.backend.repositories.Repository;
import org.uberfire.backend.server.config.ConfigGroup;
import org.uberfire.backend.server.config.ConfigItem;
import org.uberfire.backend.server.config.PasswordService;
import org.uberfire.backend.server.repositories.Location;
import org.uberfire.backend.server.repositories.RepositoryFactoryHelper;
import org.uberfire.backend.server.repositories.git.LocalGitRepository;
import org.uberfire.backend.server.repositories.git.RemoteGitRepository;

@ApplicationScoped
public class GitRepositoryFactoryHelper
implements RepositoryFactoryHelper {
    @Inject
    private PasswordService secureService;

    public boolean accept(ConfigGroup repoConfig) {
        Preconditions.checkNotNull((String)"repoConfig", (Object)repoConfig);
        ConfigItem schemeConfigItem = repoConfig.getConfigItem("scheme");
        Preconditions.checkNotNull((String)"schemeConfigItem", (Object)schemeConfigItem);
        return "git".equals(schemeConfigItem.getValue());
    }

    public Repository newRepository(ConfigGroup repoConfig) {
        Preconditions.checkNotNull((String)"repoConfig", (Object)repoConfig);
        ConfigItem schemeConfigItem = repoConfig.getConfigItem("scheme");
        Preconditions.checkNotNull((String)"schemeConfigItem", (Object)schemeConfigItem);
        ConfigItem locationConfigItem = repoConfig.getConfigItem("location");
        Preconditions.checkNotNull((String)"locationConfigItem", (Object)locationConfigItem);
        LocalGitRepository repository = null;
        Location location = Location.valueOf((String)locationConfigItem.getValue());
        switch (location) {
            case LOCAL: {
                repository = new LocalGitRepository(repoConfig.getName());
                break;
            }
            case REMOTE: {
                repository = new RemoteGitRepository(repoConfig.getName());
                this.addEnvironmentParameter(repository, repoConfig, "origin");
            }
        }
        this.addEnvironmentParameter(repository, repoConfig, "username");
        this.addSecureEnvironmentParameter(repository, repoConfig, "password");
        if (!repository.isValid()) {
            throw new IllegalStateException("Repository " + repoConfig.getName() + " not valid");
        }
        return repository;
    }

    private void addEnvironmentParameter(Repository repository, ConfigGroup repoConfig, String name) {
        String value = repoConfig.getConfigItemValue(name);
        if (value == null) {
            return;
        }
        repository.addEnvironmentParameter(name, (Object)value);
    }

    private void addSecureEnvironmentParameter(Repository repository, ConfigGroup repoConfig, String name) {
        String encryptedValue = repoConfig.getConfigItemValue(name);
        if (encryptedValue == null) {
            return;
        }
        String decryptedValue = this.secureService.decrypt(encryptedValue);
        repository.addEnvironmentParameter(name, (Object)decryptedValue);
    }
}

