import { JavaCollection } from "../../java-wrappers/JavaCollection";
import { ErraiObject } from "../model/ErraiObject";
import { MarshallingContext } from "../MarshallingContext";
import { Portable } from "../Portable";
import { NullableMarshaller } from "./NullableMarshaller";
import { UnmarshallingContext } from "../UnmarshallingContext";
import { JavaArrayList, JavaHashSet } from "../../java-wrappers";
declare abstract class JavaCollectionMarshaller<T extends Iterable<Portable<any> | null>> extends NullableMarshaller<JavaCollection<T>, ErraiObject, ErraiObject, T> {
    notNullMarshall(input: JavaCollection<T>, ctx: MarshallingContext): ErraiObject;
    notNullUnmarshall(input: ErraiObject, ctx: UnmarshallingContext): T;
    protected abstract fromArray(values: Array<Portable<any>>): JavaCollection<T>;
    private static isValid;
}
export declare class JavaArrayListMarshaller extends JavaCollectionMarshaller<Array<Portable<any> | null>> {
    protected fromArray(values: Array<Portable<any>>): JavaArrayList<Portable<any>>;
}
export declare class JavaHashSetMarshaller extends JavaCollectionMarshaller<Set<Portable<any> | null>> {
    protected fromArray(values: Array<Portable<any>>): JavaHashSet<Portable<any>>;
}
export {};
