/*
 * Decompiled with CFR 0.152.
 */
package twitter4j.media;

import twitter4j.Twitter;
import twitter4j.TwitterException;
import twitter4j.TwitterFactory;
import twitter4j.auth.Authorization;
import twitter4j.auth.OAuthAuthorization;
import twitter4j.conf.Configuration;
import twitter4j.internal.http.HttpParameter;
import twitter4j.media.AbstractImageUploadImpl;

class YFrogUpload
extends AbstractImageUploadImpl {
    public YFrogUpload(Configuration conf, OAuthAuthorization oauth) {
        super(conf, oauth);
    }

    @Override
    protected String postUpload() throws TwitterException {
        int statusCode = this.httpResponse.getStatusCode();
        if (statusCode != 200) {
            throw new TwitterException("YFrog image upload returned invalid status code", this.httpResponse);
        }
        String response = this.httpResponse.asString();
        if (response.contains("<rsp stat=\"fail\">")) {
            String error = response.substring(response.indexOf("msg") + 5, response.lastIndexOf("\""));
            throw new TwitterException("YFrog image upload failed with this error message: " + error, this.httpResponse);
        }
        if (response.contains("<rsp stat=\"ok\">")) {
            return response.substring(response.indexOf("<mediaurl>") + "<mediaurl>".length(), response.indexOf("</mediaurl>"));
        }
        throw new TwitterException("Unknown YFrog response", this.httpResponse);
    }

    @Override
    protected void preUpload() throws TwitterException {
        this.uploadUrl = "https://yfrog.com/api/xauth_upload";
        String signedVerifyCredentialsURL = this.generateVerifyCredentialsAuthorizationURL("https://api.twitter.com/1/account/verify_credentials.xml");
        Twitter tw = new TwitterFactory().getInstance((Authorization)this.oauth);
        HttpParameter[] params = new HttpParameter[]{new HttpParameter("auth", "oauth"), new HttpParameter("username", tw.verifyCredentials().getScreenName()), new HttpParameter("verify_url", signedVerifyCredentialsURL), this.image};
        if (this.message != null) {
            params = this.appendHttpParameters(new HttpParameter[]{this.message}, params);
        }
        this.postParameter = params;
    }
}

