/*
 * Decompiled with CFR 0.152.
 */
package twitter4j.media;

import twitter4j.TwitterException;
import twitter4j.conf.Configuration;
import twitter4j.http.OAuthAuthorization;
import twitter4j.internal.http.HttpParameter;
import twitter4j.media.AbstractImageUploadImpl;

class TwitgooUpload
extends AbstractImageUploadImpl {
    public TwitgooUpload(Configuration conf, OAuthAuthorization oauth) {
        super(conf, oauth);
    }

    protected String postUpload() throws TwitterException {
        int j;
        String h;
        int i;
        int statusCode = this.httpResponse.getStatusCode();
        if (statusCode != 200) {
            throw new TwitterException("Twitgoo image upload returned invalid status code", this.httpResponse);
        }
        String response = this.httpResponse.asString();
        if (-1 != response.indexOf("<rsp status=\"ok\">")) {
            int j2;
            String h2 = "<mediaurl>";
            int i2 = response.indexOf(h2);
            if (i2 != -1 && (j2 = response.indexOf("</mediaurl>", i2 + h2.length())) != -1) {
                return response.substring(i2 + h2.length(), j2);
            }
        } else if (-1 != response.indexOf("<rsp status=\"fail\">") && (i = response.indexOf(h = "msg=\"")) != -1 && (j = response.indexOf("\"", i + h.length())) != -1) {
            String msg = response.substring(i + h.length(), j);
            throw new TwitterException("Invalid Twitgoo response: " + msg);
        }
        throw new TwitterException("Unknown Twitgoo response", this.httpResponse);
    }

    protected void preUpload() throws TwitterException {
        this.uploadUrl = "http://twitgoo.com/api/uploadAndPost";
        String verifyCredentialsAuthorizationHeader = this.generateVerifyCredentialsAuthorizationHeader("https://api.twitter.com/1/account/verify_credentials.json");
        this.headers.put("X-Auth-Service-Provider", "https://api.twitter.com/1/account/verify_credentials.json");
        this.headers.put("X-Verify-Credentials-Authorization", verifyCredentialsAuthorizationHeader);
        HttpParameter[] params = new HttpParameter[]{new HttpParameter("no_twitter_post", "1"), this.image};
        if (this.message != null) {
            params = this.appendHttpParameters(new HttpParameter[]{this.message}, params);
        }
        this.postParameter = params;
    }
}

