/*
 * Decompiled with CFR 0.152.
 */
package twitter4j.media;

import twitter4j.TwitterException;
import twitter4j.conf.Configuration;
import twitter4j.http.OAuthAuthorization;
import twitter4j.internal.http.HttpParameter;
import twitter4j.media.AbstractImageUploadImpl;

class TwippleUpload
extends AbstractImageUploadImpl {
    public TwippleUpload(Configuration conf, OAuthAuthorization oauth) {
        super(conf, oauth);
    }

    protected String postUpload() throws TwitterException {
        int statusCode = this.httpResponse.getStatusCode();
        if (statusCode != 200) {
            throw new TwitterException("Twipple image upload returned invalid status code", this.httpResponse);
        }
        String response = this.httpResponse.asString();
        if (-1 != response.indexOf("<rsp stat=\"fail\">")) {
            String error = response.substring(response.indexOf("msg") + 5, response.lastIndexOf("\""));
            throw new TwitterException("Twipple image upload failed with this error message: " + error, this.httpResponse);
        }
        if (-1 != response.indexOf("<rsp stat=\"ok\">")) {
            return response.substring(response.indexOf("<mediaurl>") + "<mediaurl>".length(), response.indexOf("</mediaurl>"));
        }
        throw new TwitterException("Unknown Twipple response", this.httpResponse);
    }

    protected void preUpload() throws TwitterException {
        this.uploadUrl = "http://p.twipple.jp/api/upload";
        String signedVerifyCredentialsURL = this.generateVerifyCredentialsAuthorizationURL("https://api.twitter.com/1/account/verify_credentials.xml");
        this.postParameter = new HttpParameter[]{new HttpParameter("verify_url", signedVerifyCredentialsURL), this.image};
    }
}

