/*
 * Decompiled with CFR 0.152.
 */
package twitter4j.media;

import twitter4j.conf.Configuration;
import twitter4j.conf.ConfigurationContext;
import twitter4j.http.Authorization;
import twitter4j.http.AuthorizationFactory;
import twitter4j.http.OAuthAuthorization;
import twitter4j.media.ImageUpload;
import twitter4j.media.ImgLyUpload;
import twitter4j.media.MediaProvider;
import twitter4j.media.PlixiUpload;
import twitter4j.media.TwippleUpload;
import twitter4j.media.TwitgooUpload;
import twitter4j.media.TwitpicUpload;
import twitter4j.media.YFrogUpload;

public final class ImageUploaderFactory {
    private final Configuration conf;
    private final MediaProvider defaultMediaProvider;
    private final String apiKey;
    private final OAuthAuthorization oauth;

    public ImageUploaderFactory() {
        this(ConfigurationContext.getInstance());
    }

    public ImageUploaderFactory(Configuration conf) {
        String mediaProvider = conf.getMediaProvider().toLowerCase();
        if ("imgly".equals(mediaProvider) || "img_ly".equals(mediaProvider)) {
            this.defaultMediaProvider = MediaProvider.IMG_LY;
        } else if ("plixi".equals(mediaProvider)) {
            this.defaultMediaProvider = MediaProvider.PLIXI;
        } else if ("twipple".equals(mediaProvider)) {
            this.defaultMediaProvider = MediaProvider.TWIPPLE;
        } else if ("twitgoo".equals(mediaProvider)) {
            this.defaultMediaProvider = MediaProvider.TWITGOO;
        } else if ("twitpic".equals(mediaProvider)) {
            this.defaultMediaProvider = MediaProvider.TWITPIC;
        } else if ("yfrog".equals(mediaProvider)) {
            this.defaultMediaProvider = MediaProvider.YFROG;
        } else {
            throw new IllegalArgumentException("unsupported media provider:" + mediaProvider);
        }
        this.conf = conf;
        this.apiKey = conf.getMediaProviderAPIKey();
        Authorization authorization = AuthorizationFactory.getInstance((Configuration)conf, (boolean)true);
        if (!(authorization instanceof OAuthAuthorization)) {
            throw new IllegalArgumentException("OAuth authorization is required.");
        }
        this.oauth = (OAuthAuthorization)authorization;
    }

    public ImageUpload getInstance() {
        return this.getInstance(this.defaultMediaProvider);
    }

    public ImageUpload getInstance(MediaProvider mediaProvider) {
        if (mediaProvider == MediaProvider.IMG_LY) {
            return new ImgLyUpload(this.conf, this.oauth);
        }
        if (mediaProvider == MediaProvider.PLIXI) {
            return new PlixiUpload(this.conf, this.apiKey, this.oauth);
        }
        if (mediaProvider == MediaProvider.TWIPPLE) {
            return new TwippleUpload(this.conf, this.oauth);
        }
        if (mediaProvider == MediaProvider.TWITGOO) {
            return new TwitgooUpload(this.conf, this.oauth);
        }
        if (mediaProvider == MediaProvider.TWITPIC) {
            return new TwitpicUpload(this.conf, this.apiKey, this.oauth);
        }
        if (mediaProvider == MediaProvider.YFROG) {
            return new YFrogUpload(this.conf, this.oauth);
        }
        throw new AssertionError((Object)"Unknown provider");
    }
}

