/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.tsched.utils;

import edu.iu.dsc.tws.api.compute.graph.ComputeGraph;
import edu.iu.dsc.tws.api.compute.graph.Vertex;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;

public final class TaskVertexParser {
    private static final Logger LOG = Logger.getLogger(TaskVertexParser.class.getName());
    private List<Set<Vertex>> taskVertexList = new LinkedList<Set<Vertex>>();
    private Set<Vertex> targetVertexSet = new LinkedHashSet<Vertex>();

    public List<Set<Vertex>> parseVertexSet(ComputeGraph computeGraph) {
        Set taskVertexSet = computeGraph.getTaskVertexSet();
        for (Vertex vertex : taskVertexSet) {
            if (computeGraph.inDegreeOfTask((Object)vertex) == 0) {
                this.add(vertex);
                this.targetVertexSet.add(vertex);
                if (computeGraph.childrenOfTask((Object)vertex).size() < 1) continue;
                this.checkChildTasks(computeGraph, vertex);
                continue;
            }
            if (!this.checkChildTasks(computeGraph, vertex) || this.targetVertexSet.contains(vertex)) continue;
            this.add(vertex);
            this.targetVertexSet.add(vertex);
        }
        for (Set set : this.taskVertexList) {
            for (Vertex vertex : set) {
                LOG.fine("%%% Vertex Details:" + vertex.getName() + "\t" + set.size());
            }
        }
        return this.taskVertexList;
    }

    private boolean checkChildTasks(ComputeGraph computeGraph, Vertex vertex) {
        boolean flag = false;
        if (computeGraph.outDegreeOfTask((Object)vertex) >= 1) {
            Set childTask = computeGraph.childrenOfTask((Object)vertex);
            if (!this.targetVertexSet.containsAll(childTask)) {
                this.add(childTask);
                this.targetVertexSet.addAll(childTask);
            }
        } else {
            flag = true;
        }
        return flag;
    }

    private void add(Vertex vertex) {
        LinkedHashSet<Vertex> vertexSet = new LinkedHashSet<Vertex>();
        vertexSet.add(vertex);
        this.taskVertexList.add(vertexSet);
    }

    private void add(Set<Vertex> vertexSet) {
        this.taskVertexList.add(vertexSet);
    }
}

