/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.tsched.builder;

import com.google.common.annotations.VisibleForTesting;
import edu.iu.dsc.tws.api.compute.exceptions.TaskSchedulerException;
import edu.iu.dsc.tws.api.compute.schedule.elements.Resource;
import edu.iu.dsc.tws.api.compute.schedule.elements.TaskInstanceId;
import edu.iu.dsc.tws.api.compute.schedule.elements.TaskInstancePlan;
import edu.iu.dsc.tws.api.compute.schedule.elements.TaskSchedulePlan;
import edu.iu.dsc.tws.api.compute.schedule.elements.WorkerSchedulePlan;
import edu.iu.dsc.tws.tsched.builder.Container;
import edu.iu.dsc.tws.tsched.builder.ContainerIdScorer;
import edu.iu.dsc.tws.tsched.builder.Scorer;
import edu.iu.dsc.tws.tsched.utils.TaskScheduleUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Logger;

public class TaskSchedulePlanBuilder {
    private static final Logger LOG = Logger.getLogger(TaskSchedulePlanBuilder.class.getName());
    private TaskSchedulePlan previousTaskSchedulePlan;
    private Resource instanceDefaultResourceValue;
    private Resource containerMaximumResourceValue;
    private Map<String, Double> taskRamMap;
    private Map<String, Double> taskCpuMap;
    private Map<String, Double> taskDiskMap;
    private Map<Integer, Container> containers;
    private TreeSet<Integer> taskIds;
    private HashMap<String, TreeSet<Integer>> taskIndexes;
    private int requestedContainerPadding;
    private int numberOfContainers;
    private int id;

    public TaskSchedulePlanBuilder(int scheduleId, TaskSchedulePlan previousTaskSchedulePlan) {
        this.id = scheduleId;
        this.previousTaskSchedulePlan = previousTaskSchedulePlan;
        this.numberOfContainers = 0;
        this.requestedContainerPadding = 0;
        this.taskRamMap = new HashMap<String, Double>();
    }

    public Map<Integer, Container> getContainers() {
        return this.containers;
    }

    public void setContainers(Map<Integer, Container> containers) {
        this.containers = containers;
    }

    public TaskSchedulePlanBuilder setTaskRamMap(Map<String, Double> taskramMap) {
        this.taskRamMap = taskramMap;
        return this;
    }

    public TaskSchedulePlanBuilder setTaskDiskMap(Map<String, Double> taskdiskMap) {
        this.taskDiskMap = taskdiskMap;
        return this;
    }

    public TaskSchedulePlanBuilder setTaskCpuMap(Map<String, Double> taskcpuMap) {
        this.taskCpuMap = taskcpuMap;
        return this;
    }

    public int getJobId() {
        return this.id;
    }

    public void setJobId(int jobId) {
        this.id = jobId;
    }

    public TaskSchedulePlanBuilder setInstanceDefaultResourceValue(Resource defaultResourcevalue) {
        this.instanceDefaultResourceValue = defaultResourcevalue;
        return this;
    }

    public TaskSchedulePlanBuilder setContainerMaximumResourceValue(Resource containerMaxResourceValue) {
        this.containerMaximumResourceValue = containerMaxResourceValue;
        return this;
    }

    public TaskSchedulePlanBuilder setRequestedContainerPadding(int reqContainerPadding) {
        this.requestedContainerPadding = reqContainerPadding;
        return this;
    }

    public TaskSchedulePlanBuilder updateNumContainers(int numOfContainers) {
        this.numberOfContainers = numOfContainers;
        return this;
    }

    private static void addToContainer(Container container, TaskInstancePlan taskInstancePlan, Map<String, TreeSet<Integer>> taskIndexes, Set<Integer> taskIds) throws TaskSchedulerException {
        container.add(taskInstancePlan);
        String taskName = taskInstancePlan.getTaskName();
        if (taskIndexes.get(taskName) == null) {
            taskIndexes.put(taskName, new TreeSet());
        }
        taskIndexes.get(taskName).add(taskInstancePlan.getTaskIndex());
        taskIds.add(taskInstancePlan.getTaskId());
    }

    public TaskSchedulePlanBuilder addInstance(Integer containerId, String taskName) throws TaskSchedulerException {
        this.initContainer(containerId);
        int taskId = this.taskIds.isEmpty() ? 1 : this.taskIds.last() + 1;
        int taskIndex = this.taskIndexes.get(taskName) != null ? this.taskIndexes.get(taskName).last() + 1 : 0;
        TaskInstanceId taskInstanceId = new TaskInstanceId(taskName, taskId, taskIndex);
        Resource resource = TaskScheduleUtils.getResourceRequirement(taskName, this.taskRamMap, this.instanceDefaultResourceValue, this.containerMaximumResourceValue, this.requestedContainerPadding);
        try {
            TaskSchedulePlanBuilder.addToContainer(this.containers.get(containerId), new TaskInstancePlan(taskInstanceId, resource), this.taskIndexes, this.taskIds);
        }
        catch (TaskSchedulerException e) {
            throw new TaskSchedulerException(String.format("Insufficient container resources to add instance %s with resources %s to container %d.", taskInstanceId, resource, containerId), (Throwable)e);
        }
        LOG.info("Task id, index, name:" + taskId + "\t" + taskIndex + "\t" + taskName + "\tadded to Container:" + this.containers.get(containerId));
        return this;
    }

    public void addInstance(Scorer<Container> scorer, String taskName) throws TaskSchedulerException {
        LinkedList<Scorer<Container>> scorers = new LinkedList<Scorer<Container>>();
        scorers.add(scorer);
        this.addInstance(scorers, taskName);
    }

    private int addInstance(List<Scorer<Container>> scorers, String taskName) throws TaskSchedulerException {
        this.initContainers();
        for (Container container : TaskSchedulePlanBuilder.sortContainers(scorers, this.containers.values())) {
            try {
                this.addInstance(container.getContainerId(), taskName);
                return container.getContainerId();
            }
            catch (TaskSchedulerException taskSchedulerException) {
            }
        }
        throw new TaskSchedulerException(String.format("Insufficient resources to add '%s' instance to any of the %d containers.", taskName, this.containers.size()));
    }

    @VisibleForTesting
    private static List<Container> sortContainers(List<Scorer<Container>> scorers, Collection<Container> containers) {
        ArrayList<Container> sorted = new ArrayList<Container>(containers);
        sorted.sort(new ChainedContainerComparator(scorers));
        return sorted;
    }

    public TaskSchedulePlan build() {
        this.assertResourceSettings();
        Set<WorkerSchedulePlan> workerSchedulePlans = this.buildContainerPlans(this.containers, this.taskRamMap, this.instanceDefaultResourceValue);
        return new TaskSchedulePlan(this.id, workerSchedulePlans);
    }

    private void initContainers() {
        this.assertResourceSettings();
        Map<Integer, Container> containerMap = this.containers;
        HashMap<String, TreeSet<Integer>> taskindexes = this.taskIndexes;
        TreeSet<Integer> taskids = this.taskIds;
        if (taskindexes == null) {
            taskindexes = new HashMap();
        }
        if (taskids == null) {
            taskids = new TreeSet();
        }
        if (containerMap == null) {
            if (this.previousTaskSchedulePlan == null) {
                containerMap = new HashMap<Integer, Container>();
                for (int containerId = 1; containerId <= this.numberOfContainers; ++containerId) {
                    containerMap.put(containerId, new Container(containerId, this.containerMaximumResourceValue, this.requestedContainerPadding));
                }
            } else {
                try {
                    containerMap = this.getContainers(this.previousTaskSchedulePlan, this.requestedContainerPadding, taskindexes, taskids);
                }
                catch (TaskSchedulerException e) {
                    throw new TaskSchedulerException("Could not initialize containers using existing packing plan", (Throwable)e);
                }
            }
        }
        if (this.numberOfContainers > containerMap.size()) {
            ArrayList<Scorer<Container>> scorers = new ArrayList<Scorer<Container>>();
            scorers.add(new ContainerIdScorer());
            List<Container> sortedContainers = TaskSchedulePlanBuilder.sortContainers(scorers, containerMap.values());
            int nextContainerId = sortedContainers.get(sortedContainers.size() - 1).getContainerId() + 1;
            Resource capacity = containerMap.get(sortedContainers.get(0).getContainerId()).getResource();
            for (int i = 0; i < this.numberOfContainers - containerMap.size(); ++i) {
                containerMap.put(nextContainerId, new Container(nextContainerId, capacity, this.requestedContainerPadding));
                ++nextContainerId;
            }
        }
        this.taskIds = taskids;
        this.taskIndexes = taskindexes;
        this.containers = containerMap;
    }

    private void initContainer(int containerId) {
        this.initContainers();
        if (this.containers.get(containerId) == null) {
            this.containers.put(containerId, new Container(containerId, this.containerMaximumResourceValue, this.requestedContainerPadding));
        }
    }

    private void assertResourceSettings() {
        if (this.instanceDefaultResourceValue == null) {
            throw new TaskSchedulerException("defaultInstanceResource must be set on PackingPlanBuilder before modifying containers");
        }
        if (this.containerMaximumResourceValue == null) {
            throw new TaskSchedulerException("maxContainerResource must be set on PackingPlanBuilder before modifying containers");
        }
    }

    private Set<WorkerSchedulePlan> buildContainerPlans(Map<Integer, Container> containerValue, Map<String, Double> taskramMap, Resource instdefaultresourcevalue) {
        LinkedHashSet<WorkerSchedulePlan> workerSchedulePlans = new LinkedHashSet<WorkerSchedulePlan>();
        try {
            for (Integer containerId : containerValue.keySet()) {
                Container container = containerValue.get(containerId);
                if (container.getTaskInstances().size() == 0) continue;
                double containerRAMValue = 0.0;
                double containerDiskValue = 0.0;
                double containerCPUValue = 0.0;
                HashSet<TaskInstancePlan> taskInstancePlans = new HashSet<TaskInstancePlan>();
                for (TaskInstancePlan taskInstancePlan : container.getTaskInstances()) {
                    TaskInstanceId taskInstanceId = new TaskInstanceId(taskInstancePlan.getTaskName(), taskInstancePlan.getTaskId(), taskInstancePlan.getTaskIndex());
                    double instanceRAMValue = taskramMap.containsKey(taskInstanceId.getTaskName()) ? taskramMap.get(taskInstanceId.getTaskName()).doubleValue() : instdefaultresourcevalue.getRam().doubleValue();
                    double instanceDiskValue = instdefaultresourcevalue.getDisk();
                    double instanceCPUValue = instdefaultresourcevalue.getCpu();
                    LOG.fine("Resource Container Values:Ram Value:" + (containerRAMValue += instanceRAMValue) + "\tCpu Value:" + (containerCPUValue += instanceCPUValue) + "\tDisk Value:" + (containerDiskValue += instanceDiskValue));
                    Resource resource = new Resource(Double.valueOf(instanceRAMValue), Double.valueOf(instanceDiskValue), Double.valueOf(instanceCPUValue));
                    taskInstancePlans.add(new TaskInstancePlan(taskInstanceId.getTaskName(), taskInstanceId.getTaskId(), taskInstanceId.getTaskIndex(), resource));
                }
                containerCPUValue += (double)this.requestedContainerPadding * containerCPUValue / 100.0;
                containerRAMValue += containerRAMValue + (double)this.requestedContainerPadding;
                containerDiskValue += containerDiskValue + (double)this.requestedContainerPadding;
                Resource resource = new Resource(Double.valueOf(containerRAMValue), Double.valueOf(containerDiskValue), Double.valueOf(containerCPUValue));
                WorkerSchedulePlan workerSchedulePlan = new WorkerSchedulePlan(containerId.intValue(), taskInstancePlans, resource);
                workerSchedulePlans.add(workerSchedulePlan);
            }
        }
        catch (TaskSchedulerException ne) {
            throw new RuntimeException("Exception Occured" + ne.getMessage());
        }
        return workerSchedulePlans;
    }

    private Map<Integer, Container> getContainers(TaskSchedulePlan previoustaskschedulePlan) throws TaskSchedulerException {
        HashMap<Integer, Container> containerMap = new HashMap<Integer, Container>();
        Resource resource = previoustaskschedulePlan.getMaxContainerResources();
        for (WorkerSchedulePlan currentWorkerSchedulePlan : previoustaskschedulePlan.getContainers()) {
            Container container = new Container(currentWorkerSchedulePlan.getContainerId(), resource, this.requestedContainerPadding);
            for (TaskInstancePlan instancePlan : currentWorkerSchedulePlan.getTaskInstances()) {
                try {
                    TaskSchedulePlanBuilder.addToContainer(container, instancePlan, this.taskIndexes, this.taskIds);
                }
                catch (TaskSchedulerException e) {
                    throw new TaskSchedulerException(String.format("Insufficient container resources to add instancePlan %s to container %s", instancePlan, container), (Throwable)e);
                }
            }
            containerMap.put(currentWorkerSchedulePlan.getContainerId(), container);
        }
        return containerMap;
    }

    private Map<Integer, Container> getContainers(TaskSchedulePlan previoustaskschedulePlan, int containerPadding, Map<String, TreeSet<Integer>> taskindexes, TreeSet<Integer> taskids) throws TaskSchedulerException {
        HashMap<Integer, Container> containerMap = new HashMap<Integer, Container>();
        Resource resource = previoustaskschedulePlan.getMaxContainerResources();
        for (WorkerSchedulePlan currentWorkerSchedulePlan : previoustaskschedulePlan.getContainers()) {
            Container container = new Container(currentWorkerSchedulePlan.getContainerId(), resource, containerPadding);
            for (TaskInstancePlan instancePlan : currentWorkerSchedulePlan.getTaskInstances()) {
                try {
                    TaskSchedulePlanBuilder.addToContainer(container, instancePlan, taskindexes, taskids);
                }
                catch (TaskSchedulerException e) {
                    throw new TaskSchedulerException(String.format("Insufficient container resources to add instancePlan %s to container %s", instancePlan, container), (Throwable)e);
                }
            }
            containerMap.put(currentWorkerSchedulePlan.getContainerId(), container);
        }
        return containerMap;
    }

    private static class ContainerComparator<T>
    implements Comparator<T> {
        private Scorer<T> scorer;

        ContainerComparator(Scorer<T> scorer) {
            this.scorer = scorer;
        }

        @Override
        public int compare(T thisOne, T thatOne) {
            int sign = 1;
            if (!this.scorer.sortAscending()) {
                sign = -1;
            }
            return sign * (this.getScore(thisOne) - this.getScore(thatOne));
        }

        private int getScore(T container) {
            return (int)(1000.0 * this.scorer.getScore(container));
        }
    }

    private static class EqualsComparator<T>
    implements Comparator<T> {
        private EqualsComparator() {
        }

        @Override
        public int compare(T thisOne, T thatOne) {
            return 0;
        }
    }

    private static class ChainedContainerComparator<T>
    implements Comparator<T> {
        private final Comparator<T> comparator;
        private final ChainedContainerComparator<T> tieBreaker;

        ChainedContainerComparator(List<Scorer<T>> scorers) {
            this((Queue<Scorer<T>>)new LinkedList<Scorer<T>>(scorers));
        }

        ChainedContainerComparator(Queue<Scorer<T>> scorers) {
            if (scorers.isEmpty()) {
                this.comparator = new EqualsComparator();
                this.tieBreaker = null;
            } else {
                this.comparator = new ContainerComparator<T>(scorers.remove());
                this.tieBreaker = new ChainedContainerComparator<T>(scorers);
            }
        }

        @Override
        public int compare(T thisOne, T thatOne) {
            int delta = this.comparator.compare(thisOne, thatOne);
            if (delta != 0 || this.tieBreaker == null) {
                return delta;
            }
            return this.tieBreaker.compare(thisOne, thatOne);
        }
    }
}

