/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.tsched.builder;

import edu.iu.dsc.tws.api.compute.exceptions.TaskSchedulerException;
import edu.iu.dsc.tws.api.compute.schedule.elements.Resource;
import edu.iu.dsc.tws.api.compute.schedule.elements.TaskInstancePlan;
import java.util.HashSet;

public class Container {
    private int containerId;
    private HashSet<TaskInstancePlan> taskInstances;
    private Resource resource;
    private int paddingPercentage;

    public Container(int containerId, Resource containerMaximumResourceValue, int requestedContainerPadding) {
        this.containerId = containerId;
        this.resource = containerMaximumResourceValue;
        this.taskInstances = new HashSet();
        this.paddingPercentage = requestedContainerPadding;
    }

    public int getContainerId() {
        return this.containerId;
    }

    public void setContainerId(int containerId) {
        this.containerId = containerId;
    }

    public HashSet<TaskInstancePlan> getTaskInstances() {
        return this.taskInstances;
    }

    public Resource getResource() {
        return this.resource;
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }

    void add(TaskInstancePlan taskInstancePlan) throws TaskSchedulerException {
        if (this.taskInstances.contains(taskInstancePlan)) {
            throw new TaskSchedulerException(String.format("Instance %s already exists in container %s", taskInstancePlan, this.toString()));
        }
        this.assertHasSpace(taskInstancePlan.getResource());
        this.taskInstances.add(taskInstancePlan);
    }

    private void assertHasSpace(Resource resourceValue) throws TaskSchedulerException {
        Resource usedResources = this.getTotalUsedResources();
        double newRam = usedResources.getRam() + resourceValue.getRam() + (double)this.paddingPercentage;
        double newDisk = usedResources.getDisk() + resourceValue.getDisk() + (double)this.paddingPercentage;
        double newCpu = usedResources.getCpu() + resourceValue.getCpu() + (double)this.paddingPercentage;
        if (newRam > this.resource.getRam()) {
            throw new TaskSchedulerException(String.format("Adding %s bytes of ram to existing %s bytes with %d percent padding would exceed capacity %s", resourceValue.getRam(), usedResources.getRam(), this.paddingPercentage, this.resource.getRam()));
        }
        if (newDisk > this.resource.getDisk()) {
            throw new TaskSchedulerException(String.format("Adding %s bytes of disk to existing %s bytes with %s percent padding would exceed capacity %s", resourceValue.getDisk(), usedResources.getDisk(), this.paddingPercentage, this.resource.getDisk()));
        }
        if (newCpu > this.resource.getCpu()) {
            throw new TaskSchedulerException(String.format("Adding %s cores to existing %s cores with %d percent padding would exceed capacity %s", resourceValue.getCpu(), usedResources.getCpu(), this.paddingPercentage, this.resource.getCpu()));
        }
    }

    private Resource getTotalUsedResources() {
        double usedRam = 0.0;
        double usedCpuCores = 0.0;
        double usedDisk = 0.0;
        for (TaskInstancePlan instancePlan : this.taskInstances) {
            Resource instancePlanResource = instancePlan.getResource();
            usedRam += instancePlanResource.getRam().doubleValue();
            usedCpuCores += instancePlanResource.getCpu().doubleValue();
            usedDisk += instancePlanResource.getDisk().doubleValue();
        }
        return new Resource(Double.valueOf(usedRam), Double.valueOf(usedDisk), Double.valueOf(usedCpuCores));
    }

    public String toString() {
        return String.format("{containerId=%s, instances=%s, resource=%s, paddingPercentage=%s}", this.containerId, this.taskInstances, this.resource, this.paddingPercentage);
    }
}

