/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.task.window.policy.trigger;

import edu.iu.dsc.tws.task.window.api.Event;
import edu.iu.dsc.tws.task.window.config.WindowConfig;
import edu.iu.dsc.tws.task.window.constant.WindowType;
import edu.iu.dsc.tws.task.window.policy.trigger.IWindowingPolicy;

public class WindowingPolicy<T>
implements IWindowingPolicy<T> {
    private static final long serialVersionUID = -2786001848413534229L;
    private static final String RULE = "WindowType NOT NULL && (Window Count > 0 || Window Duration NOT NULL)";
    private WindowType windowType;
    private WindowConfig.Count count;
    private WindowConfig.Duration duration;

    public WindowingPolicy(WindowType windowType, WindowConfig.Count count) {
        this.windowType = windowType;
        this.count = count;
    }

    public WindowingPolicy(WindowType windowType, WindowConfig.Duration duration) {
        this.windowType = windowType;
        this.duration = duration;
    }

    public WindowType getWindowType() {
        return this.windowType;
    }

    public WindowConfig.Count getCount() {
        return this.count;
    }

    public WindowConfig.Duration getDuration() {
        return this.duration;
    }

    @Override
    public boolean validate() {
        return this.windowType != null && this.count.value > 0L || this.duration != null;
    }

    @Override
    public String whyInvalid() {
        return String.format("Rule : %s, Current Config :WindowType : %s, Window Count : %d, Window Duration : %s", new Object[]{RULE, this.windowType, this.count.value, this.duration});
    }

    @Override
    public void track(Event<T> event) {
    }

    @Override
    public void reset() {
    }

    @Override
    public void start() {
    }

    @Override
    public void shutdown() {
    }
}

