/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.task.window.policy.eviction.duration;

import edu.iu.dsc.tws.task.window.api.Event;
import edu.iu.dsc.tws.task.window.api.IEvictionContext;
import edu.iu.dsc.tws.task.window.api.IEvictionPolicy;
import edu.iu.dsc.tws.task.window.constant.Action;
import java.util.logging.Logger;

public class DurationEvictionPolicy<T>
implements IEvictionPolicy<T> {
    private static final Logger LOG = Logger.getLogger(DurationEvictionPolicy.class.getName());
    protected Long referenceTime;
    private long delta;
    private final long windowLength;
    protected IEvictionContext evictionContext;

    public DurationEvictionPolicy(long winLength) {
        this.windowLength = winLength;
    }

    @Override
    public Action evict(Event<T> event) {
        long now = this.referenceTime == null ? System.currentTimeMillis() : this.referenceTime;
        long diff = now - event.getTimeStamp();
        if (diff >= this.windowLength + this.delta) {
            return Action.EXPIRE;
        }
        if (diff < 0L) {
            return Action.KEEP;
        }
        return Action.PROCESS;
    }

    @Override
    public void track(Event<T> event) {
    }

    @Override
    public void setContext(IEvictionContext context) {
        this.referenceTime = context.getReferenceTime();
        IEvictionContext prevContext = this.evictionContext;
        this.evictionContext = context;
        if (context.getSlidingInterval() != null) {
            if (prevContext == null) {
                this.delta = Long.MAX_VALUE;
            } else {
                this.delta = context.getReferenceTime() - prevContext.getReferenceTime() - context.getSlidingInterval();
                if (Math.abs(this.delta) > 100L) {
                    LOG.warning(String.format("Possible clock drift or long running computation in window; Previous eviction time: %f, current eviction time: %f", prevContext.getReferenceTime(), (double)context.getReferenceTime().longValue()));
                }
            }
        }
    }

    public String toString() {
        return "DurationEvictionPolicy{referenceTime=" + this.referenceTime + ", delta=" + this.delta + ", windowLength=" + this.windowLength + '}';
    }
}

