/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.task.window.config;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;

public class WindowConfig
implements Serializable {
    private static final long serialVersionUID = 5892396934750193462L;

    public static class Duration
    implements Serializable {
        private static final long serialVersionUID = -8082429717934376825L;
        public final long value;

        public Duration(long value, TimeUnit timeUnit) {
            this.value = timeUnit.toMillis(value);
        }

        public static Duration of(long milliseconds) {
            return new Duration(milliseconds, TimeUnit.MILLISECONDS);
        }

        public static Duration days(long days) {
            return new Duration(days, TimeUnit.DAYS);
        }

        public static Duration hours(long hours) {
            return new Duration(hours, TimeUnit.HOURS);
        }

        public static Duration minutes(long minutes) {
            return new Duration(minutes, TimeUnit.MINUTES);
        }

        public static Duration seconds(long seconds) {
            return new Duration(seconds, TimeUnit.SECONDS);
        }

        public String toString() {
            return "Duration{value=" + this.value + '}';
        }
    }

    public static class Count
    implements Serializable {
        private static final long serialVersionUID = 8272120867802383759L;
        public final long value;

        public Count(long value) {
            this.value = value;
        }

        public String toString() {
            return "Count{value=" + this.value + '}';
        }
    }
}

