/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.task.impl.ops;

import edu.iu.dsc.tws.api.comms.Op;
import edu.iu.dsc.tws.api.comms.messaging.types.MessageType;
import edu.iu.dsc.tws.api.compute.IFunction;
import edu.iu.dsc.tws.api.compute.graph.Edge;
import edu.iu.dsc.tws.task.impl.ComputeConnection;
import edu.iu.dsc.tws.task.impl.function.ReduceFn;
import edu.iu.dsc.tws.task.impl.ops.AbstractOpsConfig;

public class ReduceConfig
extends AbstractOpsConfig<ReduceConfig> {
    private IFunction redFunction;
    private Op op;

    public ReduceConfig(String source, ComputeConnection computeConnection) {
        this(source, "reduce", computeConnection);
    }

    protected ReduceConfig(String source, String operationName, ComputeConnection computeConnection) {
        super(source, operationName, computeConnection);
    }

    public <T> ReduceConfig withReductionFunction(Class<T> tClass, IFunction<T> reductionFunction) {
        this.redFunction = reductionFunction;
        return this;
    }

    public ReduceConfig withReductionFunction(IFunction reductionFunction) {
        this.redFunction = reductionFunction;
        return this;
    }

    public ReduceConfig withOperation(Op operation, MessageType dataType) {
        this.op = operation;
        return (ReduceConfig)this.withDataType(dataType);
    }

    public static void validateReduce(IFunction reductionFunction, Op operation, MessageType dataType) {
        if (reductionFunction == null && operation == null) {
            ReduceConfig.failValidation("Either reduction function or Operation should be specified when declaring reduce operations.");
        }
        if (reductionFunction != null && operation != null) {
            ReduceConfig.failValidation("Both Reduction Function and Op can't be assigned for a single reduce operation.");
        }
        if (operation != null && dataType == null) {
            ReduceConfig.failValidation("Data type should specified for a reduce operation with an Op.");
        }
        if (operation != null && !dataType.isPrimitive()) {
            ReduceConfig.failValidation("Reduce operations are only applicable to primitive types.");
        }
    }

    @Override
    void validate() {
        ReduceConfig.validateReduce(this.redFunction, this.op, this.getOpDataType());
    }

    public static void updateReduceEdge(Edge reduceEdge, IFunction reductionFunction, Op operation, MessageType dataType) {
        if (reductionFunction != null) {
            reduceEdge.setFunction(reductionFunction);
        } else if (operation != null) {
            reduceEdge.setFunction((IFunction)new ReduceFn(operation, dataType));
        }
    }

    @Override
    protected Edge updateEdge(Edge newEdge) {
        ReduceConfig.updateReduceEdge(newEdge, this.redFunction, this.op, this.getOpDataType());
        return newEdge;
    }
}

