/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.task.impl.ops;

import edu.iu.dsc.tws.api.compute.graph.Edge;
import edu.iu.dsc.tws.task.impl.ComputeConnection;
import edu.iu.dsc.tws.task.impl.ops.AbstractKeyedOpsConfig;
import java.util.Comparator;

public class KeyedGatherConfig
extends AbstractKeyedOpsConfig<KeyedGatherConfig> {
    private Comparator keyCompartor;
    private boolean grpByKey = true;

    public KeyedGatherConfig(String parent, ComputeConnection computeConnection) {
        super(parent, "keyed_gather", computeConnection);
    }

    public <T> KeyedGatherConfig sortBatchByKey(Comparator<T> keyComparator) {
        this.keyCompartor = keyComparator;
        return (KeyedGatherConfig)((KeyedGatherConfig)this.withProperty("sort-by-key", keyComparator != null)).withProperty("key-comparator", keyComparator);
    }

    public <T> KeyedGatherConfig sortBatchByKey(Class<T> tClass, Comparator<T> keyComparator) {
        this.keyCompartor = keyComparator;
        return (KeyedGatherConfig)((KeyedGatherConfig)this.withProperty("sort-by-key", keyComparator != null)).withProperty("key-comparator", keyComparator);
    }

    public KeyedGatherConfig groupBatchByKey(boolean groupByKey) {
        this.grpByKey = groupByKey;
        return (KeyedGatherConfig)this.withProperty("group-by-key", groupByKey);
    }

    @Override
    void validate() {
    }

    @Override
    protected Edge updateEdge(Edge newEdge) {
        if (this.keyCompartor != null) {
            newEdge.addProperty("key-comparator", (Object)this.keyCompartor);
        }
        newEdge.addProperty("sort-by-key", (Object)(this.keyCompartor != null ? 1 : 0));
        newEdge.addProperty("group-by-key", (Object)this.grpByKey);
        return newEdge;
    }
}

