/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.task.impl;

import com.google.protobuf.Message;
import edu.iu.dsc.tws.api.config.Config;
import edu.iu.dsc.tws.api.exceptions.TimeoutException;
import edu.iu.dsc.tws.api.resource.IPersistentVolume;
import edu.iu.dsc.tws.api.resource.IVolatileVolume;
import edu.iu.dsc.tws.api.resource.IWorker;
import edu.iu.dsc.tws.api.resource.IWorkerController;
import edu.iu.dsc.tws.api.resource.WorkerEnvironment;
import edu.iu.dsc.tws.master.worker.JMSenderToDriver;
import edu.iu.dsc.tws.master.worker.JMWorkerAgent;
import edu.iu.dsc.tws.proto.system.JobExecutionState;
import edu.iu.dsc.tws.task.ComputeEnvironment;
import edu.iu.dsc.tws.task.impl.TaskExecutor;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class TaskWorker
implements IWorker {
    private static final Logger LOG = Logger.getLogger(TaskWorker.class.getName());
    protected WorkerEnvironment workerEnvironment;
    protected int workerId;
    protected IWorkerController workerController;
    protected IPersistentVolume persistentVolume;
    protected IVolatileVolume volatileVolume;
    protected Config config;
    protected TaskExecutor taskExecutor;
    protected ComputeEnvironment computeEnvironment;

    public void execute(Config cfg, int workerID, IWorkerController wController, IPersistentVolume pVolume, IVolatileVolume vVolume) {
        this.config = cfg;
        this.workerId = workerID;
        this.workerController = wController;
        this.persistentVolume = pVolume;
        this.volatileVolume = vVolume;
        JMSenderToDriver senderToDriver = JMWorkerAgent.getJMWorkerAgent().getSenderToDriver();
        this.workerEnvironment = WorkerEnvironment.init((Config)this.config, (int)workerID, (IWorkerController)this.workerController, (IPersistentVolume)pVolume, (IVolatileVolume)vVolume);
        this.computeEnvironment = ComputeEnvironment.init(this.workerEnvironment);
        this.taskExecutor = this.computeEnvironment.getTaskExecutor();
        this.execute();
        try {
            this.workerEnvironment.getWorkerController().waitOnBarrier();
        }
        catch (TimeoutException timeoutException) {
            LOG.log(Level.SEVERE, timeoutException.getMessage(), timeoutException);
        }
        this.computeEnvironment.close();
        this.workerEnvironment.close();
        JobExecutionState.WorkerJobState workerState = JobExecutionState.WorkerJobState.newBuilder().setFailure(false).setJobName(this.config.getStringValue("twister2.job.id")).setWorkerMessage("Worker Completed").build();
        senderToDriver.sendToDriver((Message)workerState);
        LOG.log(Level.FINE, String.format("%d Worker done", workerID));
    }

    public abstract void execute();
}

