/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.task.dataobjects;

import edu.iu.dsc.tws.api.compute.TaskContext;
import edu.iu.dsc.tws.api.compute.nodes.BaseSource;
import edu.iu.dsc.tws.api.config.Config;
import edu.iu.dsc.tws.api.data.Path;
import edu.iu.dsc.tws.data.api.InputPartitioner;
import edu.iu.dsc.tws.data.api.formatters.LocalCompleteTextInputPartitioner;
import edu.iu.dsc.tws.data.fs.io.InputSplit;
import edu.iu.dsc.tws.dataset.DataSource;
import edu.iu.dsc.tws.executor.core.ExecutionRuntime;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DataFileReplicatedReadSource
extends BaseSource {
    private static final Logger LOG = Logger.getLogger(DataFileReplicatedReadSource.class.getName());
    private static final long serialVersionUID = -1L;
    private DataSource<?, ?> source;
    private String edgeName;
    private String dataDirectory;
    private int dataSize;

    public String getDataDirectory() {
        return this.dataDirectory;
    }

    public void setDataDirectory(String dataDirectory) {
        this.dataDirectory = dataDirectory;
    }

    public DataFileReplicatedReadSource(String edgename, String directory) {
        this.edgeName = edgename;
        this.dataDirectory = directory;
    }

    public DataFileReplicatedReadSource(String edgename, String directory, int dSize) {
        this.edgeName = edgename;
        this.dataDirectory = directory;
        this.dataSize = dSize;
    }

    public String getEdgeName() {
        return this.edgeName;
    }

    public void setEdgeName(String edgeName) {
        this.edgeName = edgeName;
    }

    public DataFileReplicatedReadSource() {
    }

    public void execute() {
        LOG.fine("Context Task Index:" + this.context.taskIndex() + "\t" + this.getEdgeName());
        InputSplit inputSplit = this.source.getNextSplit(this.context.taskIndex());
        while (inputSplit != null) {
            try {
                while (!inputSplit.reachedEnd()) {
                    Object value = inputSplit.nextRecord(null);
                    if (value == null) continue;
                    this.context.write(this.getEdgeName(), value);
                }
                inputSplit = this.source.getNextSplit(this.context.taskIndex());
            }
            catch (IOException e) {
                LOG.log(Level.SEVERE, "Failed to read the input", e);
            }
        }
        this.context.end(this.getEdgeName());
    }

    public void prepare(Config cfg, TaskContext context) {
        super.prepare(cfg, context);
        ExecutionRuntime runtime = (ExecutionRuntime)cfg.get("_twister2.runtime_");
        this.source = runtime.createInput(cfg, context, (InputPartitioner)new LocalCompleteTextInputPartitioner(new Path(this.getDataDirectory()), context.getParallelism(), this.config));
    }
}

