/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.task.window.collectives;

import edu.iu.dsc.tws.api.compute.IMessage;
import edu.iu.dsc.tws.task.window.api.IWindowMessage;
import edu.iu.dsc.tws.task.window.core.BaseWindowedSink;
import edu.iu.dsc.tws.task.window.function.FoldWindowedFunction;

public abstract class FoldWindow<T, K>
extends BaseWindowedSink<T> {
    private FoldWindowedFunction<T, K> foldWindowedFunction;

    public abstract boolean fold(K var1);

    public abstract boolean foldLateMessage(K var1);

    public FoldWindow(FoldWindowedFunction<T, K> foldWindowedFunction) {
        this.foldWindowedFunction = foldWindowedFunction;
    }

    @Override
    public boolean execute(IWindowMessage<T> windowMessage) {
        if (windowMessage != null) {
            Object current = null;
            K output = null;
            for (IMessage<T> msg : windowMessage.getWindow()) {
                Object value = msg.getContent();
                if (current == null) {
                    current = value;
                    continue;
                }
                current = this.foldWindowedFunction.onMessage(current, value);
                output = this.foldWindowedFunction.computeFold();
                this.fold(output);
            }
        }
        return true;
    }

    @Override
    public boolean getLateMessages(IMessage<T> lateMessages) {
        Object message = lateMessages.getContent();
        K outMessage = null;
        if (message != null) {
            Object newMessage = this.foldWindowedFunction.onMessage(null, message);
            outMessage = this.foldWindowedFunction.computeFold();
            this.foldLateMessage(outMessage);
        }
        return true;
    }

    @Override
    public boolean getExpire(IWindowMessage<T> expiredMessages) {
        return false;
    }
}

