/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.task.impl;

import edu.iu.dsc.tws.api.checkpointing.CheckpointingClient;
import edu.iu.dsc.tws.api.comms.Communicator;
import edu.iu.dsc.tws.api.compute.executor.ExecutionPlan;
import edu.iu.dsc.tws.api.compute.executor.IExecutionHook;
import edu.iu.dsc.tws.api.compute.executor.IExecutor;
import edu.iu.dsc.tws.api.compute.executor.INodeInstance;
import edu.iu.dsc.tws.api.compute.graph.ComputeGraph;
import edu.iu.dsc.tws.api.compute.modifiers.Collector;
import edu.iu.dsc.tws.api.compute.modifiers.IONames;
import edu.iu.dsc.tws.api.compute.modifiers.Receptor;
import edu.iu.dsc.tws.api.compute.nodes.INode;
import edu.iu.dsc.tws.api.compute.nodes.ISource;
import edu.iu.dsc.tws.api.compute.schedule.elements.TaskSchedulePlan;
import edu.iu.dsc.tws.api.compute.schedule.elements.Worker;
import edu.iu.dsc.tws.api.compute.schedule.elements.WorkerPlan;
import edu.iu.dsc.tws.api.config.Config;
import edu.iu.dsc.tws.api.dataset.DataObject;
import edu.iu.dsc.tws.api.dataset.DataPartition;
import edu.iu.dsc.tws.api.dataset.EmptyDataObject;
import edu.iu.dsc.tws.api.exceptions.Twister2RuntimeException;
import edu.iu.dsc.tws.api.faulttolerance.Fault;
import edu.iu.dsc.tws.api.faulttolerance.FaultAcceptable;
import edu.iu.dsc.tws.api.resource.WorkerEnvironment;
import edu.iu.dsc.tws.dataset.DataObjectImpl;
import edu.iu.dsc.tws.executor.core.ExecutionPlanBuilder;
import edu.iu.dsc.tws.executor.threading.ExecutorFactory;
import edu.iu.dsc.tws.proto.jobmaster.JobMasterAPI;
import edu.iu.dsc.tws.task.impl.ExecutionHookImpl;
import edu.iu.dsc.tws.task.impl.ExecutorList;
import edu.iu.dsc.tws.tsched.taskscheduler.TaskScheduler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class TaskExecutor
implements FaultAcceptable {
    private static final Logger LOG = Logger.getLogger(TaskExecutor.class.getName());
    private Config config;
    private int workerID;
    private List<JobMasterAPI.WorkerInfo> workerInfoList;
    private Communicator communicator;
    private CheckpointingClient checkpointingClient;
    private ExecutorFactory executor;
    private Map<String, DataObject> dataObjectMap = new HashMap<String, DataObject>();
    private ExecutorList currentExecutors;

    public TaskExecutor(Config cfg, int wId, List<JobMasterAPI.WorkerInfo> workerInfoList, Communicator net, CheckpointingClient checkpointingClient) {
        this.config = cfg;
        this.workerID = wId;
        this.workerInfoList = workerInfoList;
        this.communicator = net;
        this.checkpointingClient = checkpointingClient;
        this.executor = new ExecutorFactory(this.config, this.workerID, this.communicator.getChannel());
        this.currentExecutors = new ExecutorList();
    }

    public TaskExecutor(WorkerEnvironment workerEnv) {
        this.config = workerEnv.getConfig();
        this.workerID = workerEnv.getWorkerId();
        this.workerInfoList = workerEnv.getWorkerList();
        this.communicator = workerEnv.getCommunicator();
        this.checkpointingClient = workerEnv.getWorkerController().getCheckpointingClient();
        this.executor = new ExecutorFactory(this.config, this.workerID, this.communicator.getChannel());
        this.currentExecutors = new ExecutorList();
    }

    public ExecutionPlan plan(ComputeGraph graph) {
        TaskScheduler taskScheduler = new TaskScheduler();
        taskScheduler.initialize(this.config);
        WorkerPlan workerPlan = this.createWorkerPlan();
        TaskSchedulePlan taskSchedulePlan = taskScheduler.schedule(graph, workerPlan);
        ExecutionPlanBuilder executionPlanBuilder = new ExecutionPlanBuilder(this.workerID, this.workerInfoList, this.communicator, this.checkpointingClient);
        return executionPlanBuilder.build(this.config, graph, taskSchedulePlan);
    }

    public Map<String, ExecutionPlan> plan(ComputeGraph ... graph) {
        WorkerPlan workerPlan = this.createWorkerPlan();
        TaskScheduler taskScheduler = new TaskScheduler();
        taskScheduler.initialize(this.config);
        Map schedulePlanMap = taskScheduler.schedule(workerPlan, graph);
        LinkedHashMap<String, ExecutionPlan> executionPlanMap = new LinkedHashMap<String, ExecutionPlan>();
        for (ComputeGraph aGraph : graph) {
            TaskSchedulePlan taskSchedulePlan = (TaskSchedulePlan)schedulePlanMap.get(aGraph.getGraphName());
            ExecutionPlanBuilder executionPlanBuilder = new ExecutionPlanBuilder(this.workerID, this.workerInfoList, this.communicator, this.checkpointingClient);
            ExecutionPlan executionPlan = executionPlanBuilder.build(this.config, aGraph, taskSchedulePlan);
            executionPlanMap.put(aGraph.getGraphName(), executionPlan);
        }
        return executionPlanMap;
    }

    public ExecutionPlan executionPlan(ComputeGraph graph, TaskSchedulePlan taskSchedulePlan) {
        ExecutionPlanBuilder executionPlanBuilder = new ExecutionPlanBuilder(this.workerID, this.workerInfoList, this.communicator, this.checkpointingClient);
        return executionPlanBuilder.build(this.config, graph, taskSchedulePlan);
    }

    public void execute(Config taskConfig, ComputeGraph graph, ExecutionPlan plan) {
        Config newCfg = Config.newBuilder().putAll(this.config).putAll(taskConfig).build();
        IExecutor ex = this.executor.getExecutor(newCfg, plan, graph.getOperationMode(), (IExecutionHook)new ExecutionHookImpl(this.config, this.dataObjectMap, plan, this.currentExecutors));
        ex.execute();
        ex.closeExecution();
    }

    public void execute(ComputeGraph graph, ExecutionPlan plan) {
        this.execute(this.config, graph, plan);
    }

    public void execute(ComputeGraph graph) {
        ExecutionPlan plan = this.plan(graph);
        this.execute(this.config, graph, plan);
    }

    public IExecutor createExecution(ComputeGraph graph, ExecutionPlan plan) {
        IExecutor ex = this.executor.getExecutor(this.config, plan, graph.getOperationMode(), (IExecutionHook)new ExecutionHookImpl(this.config, this.dataObjectMap, plan, this.currentExecutors));
        this.currentExecutors.add(ex);
        return ex;
    }

    public IExecutor createExecution(ComputeGraph graph) {
        ExecutionPlan plan = this.plan(graph);
        IExecutor ex = this.executor.getExecutor(this.config, plan, graph.getOperationMode(), (IExecutionHook)new ExecutionHookImpl(this.config, this.dataObjectMap, plan, this.currentExecutors));
        this.currentExecutors.add(ex);
        return ex;
    }

    @Deprecated
    public void addInput(ComputeGraph graph, ExecutionPlan plan, String taskName, String inputKey, DataObject<?> input) {
        Map nodes = plan.getNodes(taskName);
        if (nodes == null) {
            return;
        }
        for (Map.Entry e : nodes.entrySet()) {
            INodeInstance node = (INodeInstance)e.getValue();
            INode task = node.getNode();
            if (task instanceof Receptor) {
                ((Receptor)task).add(inputKey, input);
                continue;
            }
            throw new RuntimeException("Cannot add input to non input instance: " + node);
        }
    }

    @Deprecated
    public void addInput(IExecutor ex, String taskName, String inputKey, DataObject<?> input) {
        this.addInput(null, ex.getExecutionPlan(), taskName, inputKey, input);
    }

    @Deprecated
    public void addSourceInput(ComputeGraph graph, ExecutionPlan plan, String inputKey, DataObject<Object> input) {
        Map nodes = plan.getNodes();
        if (nodes == null) {
            throw new RuntimeException(String.format("%d Failed to set input for non-existing existing sources: %s", this.workerID, plan.getNodeNames()));
        }
        for (Map.Entry e : nodes.entrySet()) {
            INodeInstance node = (INodeInstance)e.getValue();
            INode task = node.getNode();
            if (!(task instanceof Receptor) || !(task instanceof ISource)) continue;
            ((Receptor)task).add(inputKey, input);
        }
    }

    @Deprecated
    public void addSourceInput(IExecutor ex, String inputKey, DataObject<Object> input) {
        this.addSourceInput(null, ex.getExecutionPlan(), inputKey, input);
    }

    @Deprecated
    public <T> DataObject<T> getOutput(ComputeGraph graph, ExecutionPlan plan, String taskName) {
        return EmptyDataObject.getInstance();
    }

    @Deprecated
    public <T> DataObject<T> getOutput(ComputeGraph graph, ExecutionPlan plan, String taskName, String dataName) {
        return this.dataObjectMap.getOrDefault(dataName, EmptyDataObject.getInstance());
    }

    public <T> DataObject<T> getOutput(String varName) {
        return this.dataObjectMap.get(varName);
    }

    public boolean isOutputAvailable(String name) {
        return this.dataObjectMap.containsKey(name);
    }

    public void addInput(String name, DataObject dataObject) {
        this.dataObjectMap.put(name, dataObject);
    }

    public static void collectData(Config cfg, ExecutionPlan executionPlan, Map<String, DataObject> dataMap) {
        Map nodes = executionPlan.getNodes();
        HashMap dataObjectMapForPlan = new HashMap();
        if (nodes != null) {
            nodes.forEach((taskId, node) -> {
                INode task = node.getNode();
                if (task instanceof Collector) {
                    IONames collectibleNames = ((Collector)task).getCollectibleNames();
                    collectibleNames.forEach(arg_0 -> TaskExecutor.lambda$collectData$1(task, (Set)collectibleNames, node, dataObjectMapForPlan, cfg, arg_0));
                }
            });
        }
        dataMap.putAll(dataObjectMapForPlan);
    }

    public static void distributeData(ExecutionPlan executionPlan, Map<String, DataObject> dataMap) {
        Map nodes = executionPlan.getNodes();
        if (nodes != null) {
            nodes.forEach((id, node) -> {
                INode task = node.getNode();
                if (task instanceof Receptor) {
                    IONames receivableNames = ((Receptor)task).getReceivableNames();
                    for (String receivableName : receivableNames) {
                        DataObject dataObject = (DataObject)dataMap.get(receivableName);
                        if (dataObject == null) {
                            throw new Twister2RuntimeException("Couldn't find input data" + receivableName + " for task " + node.getId());
                        }
                        DataPartition partition = dataObject.getPartition(node.getIndex());
                        if (partition == null) {
                            throw new Twister2RuntimeException("Couldn't find input data" + receivableName + " for task index " + node.getIndex() + " of task" + node.getId());
                        }
                        ((Receptor)task).add(receivableName, dataObject);
                        ((Receptor)task).add(receivableName, partition);
                    }
                }
            });
        }
    }

    public void clearData(String var) {
        DataObject dataObject = this.dataObjectMap.remove(var);
        if (dataObject != null) {
            for (DataPartition partition : dataObject.getPartitions()) {
                partition.clear();
            }
        }
    }

    private WorkerPlan createWorkerPlan() {
        ArrayList<Worker> workers = new ArrayList<Worker>();
        for (JobMasterAPI.WorkerInfo workerInfo : this.workerInfoList) {
            Worker w = new Worker(workerInfo.getWorkerID());
            workers.add(w);
        }
        return new WorkerPlan(workers);
    }

    public void close() {
    }

    public void onFault(Fault fault) {
        this.currentExecutors.onFault(fault);
    }

    private static /* synthetic */ void lambda$collectData$1(INode task, Set collectibleNames, INodeInstance node, Map dataObjectMapForPlan, Config cfg, String name) {
        DataPartition partition = ((Collector)task).get(name);
        if (collectibleNames.size() == 1 && partition == null) {
            partition = ((Collector)task).get();
        }
        if (partition != null) {
            partition.setId(node.getIndex());
            dataObjectMapForPlan.computeIfAbsent(name, n -> new DataObjectImpl(cfg)).addPartition(partition);
        } else {
            LOG.warning(String.format("Task index %d  of task %d returned null for data %s", node.getIndex(), node.getId(), name));
        }
    }
}

