/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.task.impl;

import edu.iu.dsc.tws.api.compute.executor.IExecutor;
import edu.iu.dsc.tws.api.exceptions.Twister2Exception;
import edu.iu.dsc.tws.api.exceptions.Twister2RuntimeException;
import edu.iu.dsc.tws.api.faulttolerance.Fault;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ExecutorList {
    private static final Logger LOG = Logger.getLogger(ExecutorList.class.getName());
    private List<IExecutor> currentExecutors = Collections.synchronizedList(new ArrayList());
    private Lock lock = new ReentrantLock();

    void onFault(Fault fault) {
        this.lock.lock();
        try {
            for (IExecutor i : this.currentExecutors) {
                i.onFault(fault);
            }
        }
        catch (Twister2Exception e) {
            LOG.log(Level.SEVERE, "An error occurred while setting fault", e);
            throw new Twister2RuntimeException("An error occurred while setting fault", (Throwable)e);
        }
        finally {
            this.lock.unlock();
        }
    }

    void add(IExecutor executor) {
        this.lock.lock();
        try {
            this.currentExecutors.add(executor);
        }
        finally {
            this.lock.unlock();
        }
    }

    synchronized void remove(IExecutor remove) {
        this.lock.lock();
        try {
            this.currentExecutors.remove(remove);
        }
        finally {
            this.lock.unlock();
        }
    }
}

