/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.task.cdfw;

import com.google.protobuf.ByteString;
import edu.iu.dsc.tws.api.compute.graph.ComputeGraph;
import edu.iu.dsc.tws.api.util.KryoSerializer;
import edu.iu.dsc.tws.proto.system.job.CDFWJobAPI;
import edu.iu.dsc.tws.proto.system.job.JobAPI;
import edu.iu.dsc.tws.task.cdfw.DataFlowJobConfig;
import java.util.ArrayList;
import java.util.List;

public final class DataFlowGraph {
    private ComputeGraph graph;
    private int cpu;
    private int ramMegaBytes;
    private double diskGigaBytes;
    private int workers;
    private DataFlowJobConfig dataFlowJobConfig = new DataFlowJobConfig();
    private List<CDFWJobAPI.Input> inputs = new ArrayList<CDFWJobAPI.Input>();
    private List<CDFWJobAPI.Output> outputs = new ArrayList<CDFWJobAPI.Output>();
    private KryoSerializer kryoSerializer;
    private String graphName;
    private CDFWJobAPI.CDFWSchedulePlan cdfwSchedulePlans;
    private String graphType;
    private int iterations;
    private int iterationNumber;

    private DataFlowGraph(String name, ComputeGraph g) {
        this.graph = g;
        this.kryoSerializer = new KryoSerializer();
        this.graphName = name;
    }

    public static DataFlowGraph newSubGraphJob(String name, ComputeGraph g) {
        return new DataFlowGraph(name, g);
    }

    public CDFWJobAPI.CDFWSchedulePlan getCdfwSchedulePlans() {
        return this.cdfwSchedulePlans;
    }

    public DataFlowGraph setCdfwSchedulePlans(CDFWJobAPI.CDFWSchedulePlan cdfwSchedulePlan) {
        this.cdfwSchedulePlans = cdfwSchedulePlan;
        return this;
    }

    public DataFlowGraph setCpu(int c) {
        this.cpu = c;
        return this;
    }

    public DataFlowGraph setRamMegaBytes(int ram) {
        this.ramMegaBytes = ram;
        return this;
    }

    public DataFlowGraph setDiskGigaBytes(double disk) {
        this.diskGigaBytes = disk;
        return this;
    }

    public ComputeGraph getGraph() {
        return this.graph;
    }

    public int getCpu() {
        return this.cpu;
    }

    public int getRamMegaBytes() {
        return this.ramMegaBytes;
    }

    public double getDiskGigaBytes() {
        return this.diskGigaBytes;
    }

    public DataFlowGraph addDataFlowJobConfig(DataFlowJobConfig jobConfig) {
        this.dataFlowJobConfig.putAll(jobConfig);
        return this;
    }

    public DataFlowJobConfig getDataFlowJobConfig() {
        return this.dataFlowJobConfig;
    }

    public int getWorkers() {
        return this.workers;
    }

    public DataFlowGraph setWorkers(int w) {
        this.workers = w;
        return this;
    }

    public List<CDFWJobAPI.Input> getInputs() {
        return this.inputs;
    }

    public String getGraphName() {
        return this.graphName;
    }

    public DataFlowGraph setGraphType(String graphtype) {
        this.graphType = graphtype;
        return this;
    }

    public String getGraphType() {
        return this.graphType;
    }

    public int getIterations() {
        return this.iterations;
    }

    public DataFlowGraph setIterations(int iter) {
        this.iterations = iter;
        return this;
    }

    public int getIterationNumber() {
        return this.iterationNumber;
    }

    public DataFlowGraph setIterationNumber(int iterationnumber) {
        this.iterationNumber = iterationnumber;
        return this;
    }

    public DataFlowGraph addInput(String g, String input, String taskname) {
        this.inputs.add(CDFWJobAPI.Input.newBuilder().setParentGraph(g).setName(input).setTaskname(taskname).build());
        return this;
    }

    public DataFlowGraph addOutput(String output, String taskname) {
        this.outputs.add(CDFWJobAPI.Output.newBuilder().setName(output).setTaskname(taskname).build());
        return this;
    }

    public List<CDFWJobAPI.Output> getOutputs() {
        return this.outputs;
    }

    public CDFWJobAPI.SubGraph build() {
        JobAPI.Config.Builder configBuilder = JobAPI.Config.newBuilder();
        if (this.graphName == null) {
            throw new RuntimeException("A name should be specified");
        }
        this.dataFlowJobConfig.forEach((key, value) -> {
            byte[] objectByte = this.kryoSerializer.serialize(value);
            configBuilder.putConfigByteMap(key, ByteString.copyFrom((byte[])objectByte));
        });
        byte[] graphBytes = this.kryoSerializer.serialize((Object)this.graph);
        return CDFWJobAPI.SubGraph.newBuilder().setName(this.graphName).setConfig(configBuilder).setGraphSerialized(ByteString.copyFrom((byte[])graphBytes)).setInstances(this.workers).setCdfwScheduleplan(this.cdfwSchedulePlans).setGraphType(this.graphType).setIterations(this.iterations).setIterationNumber(this.iterationNumber).build();
    }
}

