/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.task.cdfw;

import com.google.protobuf.Any;
import edu.iu.dsc.tws.api.config.Config;
import edu.iu.dsc.tws.api.driver.IDriverMessenger;
import edu.iu.dsc.tws.api.driver.IScaler;
import edu.iu.dsc.tws.proto.jobmaster.JobMasterAPI;
import edu.iu.dsc.tws.task.cdfw.CDFWExecutor;
import edu.iu.dsc.tws.task.cdfw.DataFlowGraph;
import java.util.List;
import java.util.logging.Logger;

public class CDFWEnv {
    private static final Logger LOG = Logger.getLogger(CDFWEnv.class.getName());
    private CDFWExecutor cdfwExecutor;
    private IScaler resourceScaler;
    private Config config;
    private volatile List<JobMasterAPI.WorkerInfo> workerInfoList;
    private Object waitObject = new Object();

    public CDFWEnv(Config config, IScaler resourceScaler, IDriverMessenger driverMessenger, List<JobMasterAPI.WorkerInfo> workers) {
        this.resourceScaler = resourceScaler;
        this.config = config;
        this.workerInfoList = workers;
        this.cdfwExecutor = new CDFWExecutor(this, driverMessenger);
    }

    public Config getConfig() {
        return this.config;
    }

    public void executeDataFlowGraph(DataFlowGraph dataFlowGraph) {
        this.cdfwExecutor.execute(dataFlowGraph);
    }

    public void executeDataFlowGraph(DataFlowGraph ... dataFlowGraph) {
        this.cdfwExecutor.executeCDFW(dataFlowGraph);
    }

    public boolean increaseWorkers(int workers) {
        this.resourceScaler.scaleUpWorkers(workers);
        this.waitAllWorkersToJoin();
        return true;
    }

    public boolean decreaseWorkers(int workers) {
        this.resourceScaler.scaleDownWorkers(workers);
        return true;
    }

    public List<JobMasterAPI.WorkerInfo> getWorkerInfoList() {
        return this.workerInfoList;
    }

    public void workerMessageReceived(Any anyMessage, int senderWorkerID) {
        this.cdfwExecutor.workerMessageReceived(anyMessage, senderWorkerID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void allWorkersJoined(List<JobMasterAPI.WorkerInfo> workerList) {
        this.workerInfoList = workerList;
        Object object = this.waitObject;
        synchronized (object) {
            this.waitObject.notify();
        }
    }

    public void close() {
        this.cdfwExecutor.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitAllWorkersToJoin() {
        Object object = this.waitObject;
        synchronized (object) {
            try {
                LOG.info("Waiting for all workers to join the job... ");
                this.waitObject.wait();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                return;
            }
        }
    }
}

