/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.task.cdfw;

import com.google.protobuf.Any;
import edu.iu.dsc.tws.api.config.Config;
import edu.iu.dsc.tws.api.driver.IDriver;
import edu.iu.dsc.tws.api.driver.IDriverMessenger;
import edu.iu.dsc.tws.api.driver.IScaler;
import edu.iu.dsc.tws.proto.jobmaster.JobMasterAPI;
import edu.iu.dsc.tws.task.cdfw.CDFWEnv;
import edu.iu.dsc.tws.task.cdfw.DriverState;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.logging.Logger;

public abstract class BaseDriver
implements IDriver {
    private static final Logger LOG = Logger.getLogger(BaseDriver.class.getName());
    private CDFWEnv executionEnv;
    private BlockingQueue<List<JobMasterAPI.WorkerInfo>> driverQueue = new LinkedBlockingDeque<List<JobMasterAPI.WorkerInfo>>();
    private DriverState driverState = DriverState.WAIT_FOR_WORKERS_TO_START;

    public void execute(Config config, IScaler scaler, IDriverMessenger messenger) {
        List<JobMasterAPI.WorkerInfo> workers = this.waitForDriverInit();
        this.executionEnv = new CDFWEnv(config, scaler, messenger, workers);
        this.execute(this.executionEnv);
        this.executionEnv.close();
    }

    public abstract void execute(CDFWEnv var1);

    public void workerMessageReceived(Any anyMessage, int senderWorkerID) {
        this.executionEnv.workerMessageReceived(anyMessage, senderWorkerID);
    }

    public void allWorkersJoined(List<JobMasterAPI.WorkerInfo> workerList) {
        LOG.fine("joined worker info list:" + workerList);
        if (this.driverState != DriverState.WAIT_FOR_WORKERS_TO_START) {
            this.executionEnv.allWorkersJoined(workerList);
        } else {
            try {
                this.driverQueue.put(workerList);
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Failed to insert the event", e);
            }
        }
    }

    private List<JobMasterAPI.WorkerInfo> waitForDriverInit() {
        try {
            List<JobMasterAPI.WorkerInfo> workers = this.driverQueue.take();
            this.driverState = DriverState.INITIALIZE;
            return workers;
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Failed to take events from the queue", e);
        }
    }
}

