/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.rsched.schedulers.mesos;

import edu.iu.dsc.tws.api.resource.IVolatileVolume;
import java.io.File;

public class MesosVolatileVolume
implements IVolatileVolume {
    public static final String WORKER_DIR_NAME_PREFIX = "worker-";
    public static final String LOG_FILE_NAME_PREFIX = "worker-";
    public static final String LOG_DIR_NAME = "/logs";
    private String volatileJobDirPath;
    private String workerDirPath;
    private String logFileName;
    private String logDirPath;

    public MesosVolatileVolume(String volatileJobDirPath, int workerID) {
        this.volatileJobDirPath = volatileJobDirPath;
        this.workerDirPath = volatileJobDirPath + "/" + "worker-" + workerID;
        this.logDirPath = volatileJobDirPath + LOG_DIR_NAME;
        this.logFileName = this.logDirPath + "/" + "worker-" + workerID + ".log";
        this.createLogDir();
    }

    private void createLogDir() {
        File logDir = new File(this.logDirPath);
        if (!logDir.exists()) {
            logDir.mkdirs();
        }
    }

    public String getWorkerDirPath() {
        return this.workerDirPath;
    }

    public boolean jobDirExists() {
        return new File(this.volatileJobDirPath).exists();
    }

    public File getWorkerDir() {
        if (!this.jobDirExists()) {
            return null;
        }
        File workerDir = new File(this.workerDirPath);
        if (workerDir.exists()) {
            return workerDir;
        }
        workerDir.mkdir();
        return workerDir;
    }
}

