/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.rsched.schedulers.k8s.master;

import edu.iu.dsc.tws.api.config.Config;
import edu.iu.dsc.tws.api.driver.IScalerPerCluster;
import edu.iu.dsc.tws.api.exceptions.Twister2Exception;
import edu.iu.dsc.tws.api.exceptions.Twister2RuntimeException;
import edu.iu.dsc.tws.api.faulttolerance.FaultToleranceContext;
import edu.iu.dsc.tws.api.scheduler.SchedulerContext;
import edu.iu.dsc.tws.common.logging.LoggingHelper;
import edu.iu.dsc.tws.common.zk.ZKBarrierManager;
import edu.iu.dsc.tws.common.zk.ZKContext;
import edu.iu.dsc.tws.common.zk.ZKEphemStateManager;
import edu.iu.dsc.tws.common.zk.ZKEventsManager;
import edu.iu.dsc.tws.common.zk.ZKPersStateManager;
import edu.iu.dsc.tws.common.zk.ZKUtils;
import edu.iu.dsc.tws.master.IJobTerminator;
import edu.iu.dsc.tws.master.server.JobMaster;
import edu.iu.dsc.tws.proto.jobmaster.JobMasterAPI;
import edu.iu.dsc.tws.proto.system.job.JobAPI;
import edu.iu.dsc.tws.rsched.schedulers.k8s.K8sEnvVariables;
import edu.iu.dsc.tws.rsched.schedulers.k8s.KubernetesContext;
import edu.iu.dsc.tws.rsched.schedulers.k8s.KubernetesController;
import edu.iu.dsc.tws.rsched.schedulers.k8s.driver.K8sScaler;
import edu.iu.dsc.tws.rsched.schedulers.k8s.master.JobTerminator;
import edu.iu.dsc.tws.rsched.schedulers.k8s.worker.K8sWorkerUtils;
import edu.iu.dsc.tws.rsched.utils.JobUtils;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.curator.framework.CuratorFramework;

public final class JobMasterStarter {
    private static final Logger LOG = Logger.getLogger(JobMasterStarter.class.getName());
    public static JobAPI.Job job;

    private JobMasterStarter() {
    }

    public static void main(String[] args) {
        LoggingHelper.setLoggingFormat((String)"[%1$tF %1$tT] [%4$s] [%7$s] %3$s: %5$s %6$s %n");
        String jobID = System.getenv((Object)((Object)K8sEnvVariables.JOB_ID) + "");
        String encodedNodeInfoList = System.getenv((Object)((Object)K8sEnvVariables.ENCODED_NODE_INFO_LIST) + "");
        String hostIP = System.getenv((Object)((Object)K8sEnvVariables.HOST_IP) + "");
        String configDir = "/twister2-memory-dir/twister2-job";
        Config config = K8sWorkerUtils.loadConfig(configDir);
        String jobDescFileName = SchedulerContext.createJobDescriptionFileName((String)jobID);
        jobDescFileName = "/twister2-memory-dir/twister2-job/" + jobDescFileName;
        job = JobUtils.readJobFile(null, jobDescFileName);
        LOG.info("Job description file is loaded: " + jobDescFileName);
        config = JobUtils.overrideConfigs(job, config);
        config = JobUtils.updateConfigs(job, config);
        K8sWorkerUtils.initLogger(config, "jobMaster");
        LOG.info("JobMaster is starting. Current time: " + System.currentTimeMillis());
        LOG.info("Number of configuration parameters: " + config.size());
        InetAddress localHost = null;
        try {
            localHost = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            throw new RuntimeException("Cannot get localHost.", e);
        }
        String podIP = localHost.getHostAddress();
        JobMasterAPI.NodeInfo nodeInfo = KubernetesContext.nodeLocationsFromConfig(config) ? KubernetesContext.getNodeInfo((Config)config, (String)hostIP) : K8sWorkerUtils.getNodeInfoFromEncodedStr(encodedNodeInfoList, hostIP);
        LOG.info("NodeInfo for JobMaster: " + nodeInfo);
        JobMasterAPI.JobMasterState initialState = JobMasterAPI.JobMasterState.JM_STARTED;
        if (ZKContext.isZooKeeperServerUsed((Config)config)) {
            initialState = JobMasterStarter.initializeZooKeeper(config, jobID, podIP);
        }
        JobTerminator jobTerminator = new JobTerminator(config);
        KubernetesController controller = new KubernetesController();
        controller.init(KubernetesContext.namespace(config));
        K8sScaler k8sScaler = new K8sScaler(config, job, controller);
        JobMaster jobMaster = new JobMaster(config, podIP, (IJobTerminator)jobTerminator, job, nodeInfo, (IScalerPerCluster)k8sScaler, initialState);
        jobMaster.addShutdownHook(false);
        try {
            jobMaster.startJobMasterBlocking();
        }
        catch (Twister2Exception e) {
            LOG.log(Level.SEVERE, e.getMessage(), e);
        }
        K8sWorkerUtils.waitIndefinitely();
    }

    public static JobMasterAPI.JobMasterState initializeZooKeeper(Config config, String jobID, String jmAddress) {
        String zkServerAddresses = ZKContext.serverAddresses((Config)config);
        int sessionTimeoutMs = FaultToleranceContext.sessionTimeout((Config)config);
        CuratorFramework client = ZKUtils.connectToServer((String)zkServerAddresses, (int)sessionTimeoutMs);
        String rootPath = ZKContext.rootNode((Config)config);
        try {
            if (ZKPersStateManager.isJobMasterRestarting((CuratorFramework)client, (String)rootPath, (String)jobID, (String)jmAddress)) {
                ZKEventsManager.initEventCounter((CuratorFramework)client, (String)rootPath, (String)jobID);
                job = ZKPersStateManager.readJobZNode((CuratorFramework)client, (String)rootPath, (String)jobID);
                return JobMasterAPI.JobMasterState.JM_RESTARTED;
            }
            if (ZKUtils.isThereJobZNodes((CuratorFramework)client, (String)rootPath, (String)jobID)) {
                throw new Twister2RuntimeException("There is already a job znode at zookeeper for this job.Can not run this job.");
            }
            ZKEphemStateManager.createEphemDir((CuratorFramework)client, (String)rootPath, (String)job.getJobId());
            ZKEventsManager.createEventsZNode((CuratorFramework)client, (String)rootPath, (String)job.getJobId());
            ZKBarrierManager.createBarrierDir((CuratorFramework)client, (String)rootPath, (String)job.getJobId());
            ZKPersStateManager.createPersStateDir((CuratorFramework)client, (String)rootPath, (JobAPI.Job)job);
            ZKPersStateManager.createJobMasterPersState((CuratorFramework)client, (String)rootPath, (String)jobID, (String)jmAddress);
            return JobMasterAPI.JobMasterState.JM_STARTED;
        }
        catch (Exception e) {
            throw new Twister2RuntimeException((Throwable)e);
        }
    }
}

