/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.rsched.worker;

import edu.iu.dsc.tws.api.config.Config;
import edu.iu.dsc.tws.api.exceptions.Twister2Exception;
import edu.iu.dsc.tws.api.faulttolerance.Fault;
import edu.iu.dsc.tws.api.faulttolerance.FaultAcceptable;
import edu.iu.dsc.tws.api.resource.IAllJoinedListener;
import edu.iu.dsc.tws.api.resource.IManagedFailureListener;
import edu.iu.dsc.tws.api.resource.IPersistentVolume;
import edu.iu.dsc.tws.api.resource.IVolatileVolume;
import edu.iu.dsc.tws.api.resource.IWorker;
import edu.iu.dsc.tws.api.resource.IWorkerController;
import edu.iu.dsc.tws.api.resource.IWorkerFailureListener;
import edu.iu.dsc.tws.api.scheduler.SchedulerContext;
import edu.iu.dsc.tws.proto.jobmaster.JobMasterAPI;
import edu.iu.dsc.tws.rsched.core.WorkerRuntime;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WorkerManager
implements IManagedFailureListener,
IAllJoinedListener {
    private static final Logger LOG = Logger.getLogger(WorkerManager.class.getName());
    private List<FaultAcceptable> faultComponents = new ArrayList<FaultAcceptable>();
    private IWorker managedWorker;
    private Config config;
    private int workerId;
    private IWorkerController workerController;
    private IPersistentVolume persistentVolume;
    private IVolatileVolume volatileVolume;
    private WorkerStatus workerStatus;
    private int retries = 0;
    private final int maxRetries;
    private long startTime = 0L;
    private long failedTime = 0L;

    public WorkerManager(Config config, int workerID, IWorkerController workerController, IPersistentVolume persistentVolume, IVolatileVolume volatileVolume, IWorker worker) {
        this.config = config;
        this.workerId = workerID;
        this.workerController = workerController;
        this.persistentVolume = persistentVolume;
        this.volatileVolume = volatileVolume;
        this.managedWorker = worker;
        this.maxRetries = SchedulerContext.failureRetries((Config)config, (int)3);
        WorkerRuntime.addWorkerFailureListener((IWorkerFailureListener)this);
        this.workerStatus = WorkerStatus.RUNNING;
    }

    public void start() {
        while (this.retries < this.maxRetries) {
            if (this.workerStatus == WorkerStatus.FAILED) {
                long elapsedTime = System.currentTimeMillis() - this.failedTime;
                if (elapsedTime > 600000L) {
                    LOG.info("Waited 10 mins to recover the workers from failre, giving up");
                    break;
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (this.workerStatus == WorkerStatus.RUNNING) {
                this.managedWorker.execute(this.config, this.workerId, this.workerController, this.persistentVolume, this.volatileVolume);
                ++this.retries;
                if (this.workerStatus == WorkerStatus.RUNNING) {
                    LOG.info("Worker finished successfully");
                    break;
                }
            }
            if (this.retries < this.maxRetries) continue;
            LOG.info(String.format("Retried %d times and failed, we are exiting", this.retries));
            break;
        }
    }

    public void registerFaultComponent(FaultAcceptable fa) {
        this.faultComponents.add(fa);
    }

    public void allWorkersJoined(List<JobMasterAPI.WorkerInfo> workerList) {
    }

    public void failed(int workerID) {
        this.workerStatus = WorkerStatus.FAILED;
        this.failedTime = System.currentTimeMillis();
        for (FaultAcceptable fa : this.faultComponents) {
            try {
                fa.onFault(new Fault(workerID));
            }
            catch (Twister2Exception e) {
                LOG.log(Level.WARNING, "Cannot propergate the failure", e);
            }
        }
    }

    public void restarted(JobMasterAPI.WorkerInfo workerInfo) {
        this.workerStatus = WorkerStatus.RUNNING;
    }

    public void registerFaultAcceptor(FaultAcceptable faultAcceptable) {
        this.faultComponents.add(faultAcceptable);
    }

    public void unRegisterFaultAcceptor(FaultAcceptable faultAcceptable) {
        this.faultComponents.remove(faultAcceptable);
    }

    private static enum WorkerStatus {
        RUNNING,
        FAILED,
        RESTARTED;

    }
}

