/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.rsched.schedulers.standalone;

import edu.iu.dsc.tws.api.config.Config;
import edu.iu.dsc.tws.api.config.Context;
import edu.iu.dsc.tws.api.config.TokenSub;
import edu.iu.dsc.tws.api.scheduler.SchedulerContext;
import java.util.Map;

public class MPIContext
extends SchedulerContext {
    public static final String WORKING_DIRECTORY = "twister2.resource.scheduler.mpi.working.directory";
    public static final String SLURM_JOB_ID = "twister2.resource.scheduler.mpi.job.id";
    public static final String SLURM_SHELL_SCRIPT = "twister2.resource.scheduler.mpi.shell.script";
    public static final String PARTITION = "twister2.resource.scheduler.slurm.partition";
    public static final String MODE = "twsiter2.resource.scheduler.mpi.mode";
    public static final String NODES_FILE = "twister2.resource.scheduler.mpi.nodes.file";
    public static final String MPIRUN_FILE = "twister2.resource.scheduler.mpi.mpirun.file";
    public static final String MPI_MAP_BY = "twister2.resource.scheduler.mpi.mapby";
    public static final String MPI_MAP_BY_PE = "twister2.resource.scheduler.mpi.mapby.use-pe";
    public static final String NODES_ON_SHARED_FS = "twister2.resource.sharedfs";
    public static final String FILE_SYSTEM_MOUNT = "twister2.resource.fs.mount";
    public static final String JIP = "__job_master_ip__";
    public static final String JPORT = "__job_master_port__";

    public static String workingDirectory(Config config) {
        return TokenSub.substitute((Config)config, (String)config.getStringValue(WORKING_DIRECTORY, "${HOME}/.twister2/jobs"), (Map)Context.substitutions);
    }

    public static String jobIdFile(Config config) {
        return config.getStringValue(SLURM_JOB_ID, "mpi-job.pid");
    }

    public static String mpiShellScript(Config config) {
        return config.getStringValue(SLURM_SHELL_SCRIPT, "mpi.sh");
    }

    public static String partition(Config cfg) {
        return cfg.getStringValue(PARTITION);
    }

    public static String mpiMode(Config cfg) {
        return cfg.getStringValue(MODE, "node");
    }

    public static String nodeFiles(Config cfg) {
        return cfg.getStringValue(NODES_FILE, "nodes");
    }

    public static String mpiRunFile(Config cfg) {
        return cfg.getStringValue(MPIRUN_FILE, "mpirun");
    }

    public static String mpiMapBy(Config cfg, int cpusPerProc) {
        String mapBy = cfg.getStringValue(MPI_MAP_BY, "node");
        if (MPIContext.mpiMapByUsePE(cfg)) {
            return mapBy + ":PE=" + cpusPerProc;
        }
        return mapBy;
    }

    private static boolean mpiMapByUsePE(Config cfg) {
        return cfg.getBooleanValue(MPI_MAP_BY_PE, false);
    }

    public static boolean isSharedFs(Config cfg) {
        return cfg.getBooleanValue(NODES_ON_SHARED_FS, true);
    }

    public static String fileSystemMount(Config cfg) {
        return TokenSub.substitute((Config)cfg, (String)cfg.getStringValue(FILE_SYSTEM_MOUNT, "${TWISTER2_HOME}/persistent/fs/"), (Map)Context.substitutions);
    }
}

