/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.rsched.schedulers.nomad;

import edu.iu.dsc.tws.api.config.Config;
import edu.iu.dsc.tws.api.config.Context;
import edu.iu.dsc.tws.api.config.TokenSub;
import edu.iu.dsc.tws.api.scheduler.SchedulerContext;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class NomadContext
extends SchedulerContext {
    public static final String WORKING_DIRECTORY_ENV = "WORKING_DIRECTORY_ENV";
    public static final String DOWNLOAD_PACKAGE_ENV = "DOWNLOAD_PACKAGE_ENV";
    public static final String CORE_PACKAGE_ENV = "CORE_PACKAGE_ENV";
    public static final String JOB_PACKAGE_ENV = "JOB_PACKAGE_ENV";
    public static final String NOMAD_TASK_COMMAND = "command";
    public static final String NOMAD_TASK_COMMAND_ARGS = "args";
    public static final String NOMAD_IMAGE = "image";
    public static final String NOMAD_DEFAULT_DATACENTER = "dc1";
    public static final String SHELL_CMD = "/bin/sh";
    public static final String NOMAD_JOB_NAME = "NOMAD_JOB_NAME";
    public static final String PORT_NAMES = "twister2.network.port.names";
    public static final String SHARED_FILE_SYSTEM = "twister2.resource.filesystem.shared";
    public static final String NOMAD_SHELL_SCRIPT = "twister2.resource.nomad.shell.script";
    public static final String NOMAD_SCRIPT_NAME = "nomad.sh";
    public static final String NOMAD_URI = "twister2.resource.nomad.scheduler.uri";
    public static final String LOGGING_SANDBOX = "twister2.logging.sandbox.logging";

    public static String workingDirectory(Config config) {
        return TokenSub.substitute((Config)config, (String)config.getStringValue("twister2.working_directory", "${HOME}/.twister2/jobs"), (Map)Context.substitutions);
    }

    public static boolean sharedFileSystem(Config config) {
        return config.getBooleanValue(SHARED_FILE_SYSTEM, true);
    }

    public static String networkPortNames(Config config) {
        return config.getStringValue(PORT_NAMES, "worker");
    }

    public static String shellScriptName(Config config) {
        return config.getStringValue(NOMAD_SHELL_SCRIPT, NOMAD_SCRIPT_NAME);
    }

    public static String nomadSchedulerUri(Config config) {
        return config.getStringValue(NOMAD_URI);
    }

    public static boolean getLoggingSandbox(Config config) {
        return config.getBooleanValue(LOGGING_SANDBOX, false);
    }

    public static Map<String, Integer> generateAdditionalPorts(Config config, int workerPort) {
        List portNames = SchedulerContext.additionalPorts((Config)config);
        if (portNames == null) {
            return null;
        }
        HashMap<String, Integer> ports = new HashMap<String, Integer>();
        int i = 1;
        for (String portName : portNames) {
            ports.put(portName, workerPort + i++);
        }
        return ports;
    }
}

