/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.rsched.schedulers.mesos.master;

import edu.iu.dsc.tws.api.config.Config;
import edu.iu.dsc.tws.api.driver.IScalerPerCluster;
import edu.iu.dsc.tws.common.config.ConfigLoader;
import edu.iu.dsc.tws.common.zk.ZKJobMasterRegistrar;
import edu.iu.dsc.tws.master.IJobTerminator;
import edu.iu.dsc.tws.master.JobMasterContext;
import edu.iu.dsc.tws.master.server.JobMaster;
import edu.iu.dsc.tws.proto.jobmaster.JobMasterAPI;
import edu.iu.dsc.tws.proto.system.job.JobAPI;
import edu.iu.dsc.tws.rsched.schedulers.mesos.MesosContext;
import edu.iu.dsc.tws.rsched.schedulers.mesos.MesosController;
import edu.iu.dsc.tws.rsched.schedulers.mesos.MesosWorkerLogger;
import edu.iu.dsc.tws.rsched.schedulers.mesos.driver.MesosScaler;
import edu.iu.dsc.tws.rsched.schedulers.mesos.master.JobTerminator;
import edu.iu.dsc.tws.rsched.utils.JobUtils;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.file.Paths;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class MesosJobMasterStarter {
    private static final Logger LOG = Logger.getLogger(MesosJobMasterStarter.class.getName());

    private MesosJobMasterStarter() {
    }

    public static void main(String[] args) {
        String homeDir = System.getenv("HOME");
        int workerId = Integer.parseInt(System.getenv("WORKER_ID"));
        String jobName = System.getenv("JOB_NAME");
        String jobId = System.getenv("JOB_ID");
        String twister2Home = Paths.get("", new String[0]).toAbsolutePath().toString();
        String configDir = "twister2-job";
        Config config = ConfigLoader.loadConfig((String)twister2Home, (String)configDir, (String)"mesos");
        Config.Builder builder = Config.newBuilder().putAll(config);
        builder.put("twister2.job.id", (Object)jobId);
        config = builder.build();
        JobTerminator terminator = new JobTerminator(config, System.getenv("FRAMEWORK_ID"));
        MesosWorkerLogger logger = new MesosWorkerLogger(config, "/persistent-volume/logs", "master");
        logger.initLogging();
        MesosController controller = new MesosController(config);
        JobAPI.Job job = JobUtils.readJobFile(null, "twister2-job/" + jobName + ".job");
        ZKJobMasterRegistrar registrar = null;
        try {
            registrar = new ZKJobMasterRegistrar(config, Inet4Address.getLocalHost().getHostAddress(), 11011, job.getJobId());
            LOG.info("JobMaster REGISTERED..:" + Inet4Address.getLocalHost().getHostAddress());
        }
        catch (UnknownHostException e) {
            LOG.info("JobMaster CAN NOT BE REGISTERED:");
            e.printStackTrace();
        }
        boolean initialized = registrar.initialize();
        if (!initialized) {
            LOG.info("CAN NOT INITIALIZE");
        }
        if (!initialized && registrar.sameZNodeExist()) {
            registrar.deleteJobMasterZNode();
            registrar.initialize();
        }
        if (!JobMasterContext.jobMasterRunsInClient((Config)config)) {
            try {
                String workerIp = Inet4Address.getLocalHost().getHostAddress();
                JobMasterAPI.NodeInfo jobMasterNodeInfo = MesosContext.getNodeInfo((Config)config, (String)workerIp);
                IScalerPerCluster clusterScaler = null;
                MesosScaler mesosScaler = new MesosScaler(config, job, controller);
                mesosScaler.setFrameWorkId(System.getenv("FRAMEWORK_ID"));
                JobMasterAPI.JobMasterState initialState = JobMasterAPI.JobMasterState.JM_STARTED;
                JobMaster jobMaster = new JobMaster(config, InetAddress.getLocalHost().getHostAddress(), (IJobTerminator)terminator, job, jobMasterNodeInfo, clusterScaler, initialState);
                LOG.info("JobMaster host address...:" + InetAddress.getLocalHost().getHostAddress());
                jobMaster.startJobMasterBlocking();
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, "Exception when getting local host address: ", e);
            }
        }
        MesosJobMasterStarter.waitIndefinitely();
        registrar.deleteJobMasterZNode();
        registrar.close();
    }

    public static void waitIndefinitely() {
        while (true) {
            try {
                while (true) {
                    LOG.info("JobMasterStarter thread waiting indefinitely. Sleeping 100sec. Time: " + new Date());
                    Thread.sleep(100000L);
                }
            }
            catch (InterruptedException e) {
                LOG.warning("Thread sleep interrupted.");
                continue;
            }
            break;
        }
    }
}

