/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.rsched.schedulers.k8s.master;

import edu.iu.dsc.tws.api.config.Config;
import edu.iu.dsc.tws.master.IJobTerminator;
import edu.iu.dsc.tws.rsched.schedulers.k8s.KubernetesContext;
import edu.iu.dsc.tws.rsched.schedulers.k8s.KubernetesController;
import edu.iu.dsc.tws.rsched.schedulers.k8s.KubernetesUtils;
import java.util.ArrayList;

public class JobTerminator
implements IJobTerminator {
    private KubernetesController controller;
    private Config config;

    public JobTerminator(Config config) {
        this.config = config;
        this.controller = new KubernetesController();
        String namespace = KubernetesContext.namespace(config);
        this.controller.init(namespace);
    }

    public boolean terminateJob(String jobID) {
        ArrayList<String> ssNameLists = this.controller.getStatefulSetsForJobWorkers(jobID);
        boolean ssForWorkersDeleted = true;
        for (String ssName : ssNameLists) {
            ssForWorkersDeleted &= this.controller.deleteStatefulSet(ssName);
        }
        String serviceName = KubernetesUtils.createServiceName(jobID);
        boolean serviceForWorkersDeleted = this.controller.deleteService(serviceName);
        String pvcName = KubernetesUtils.createPersistentVolumeClaimName(jobID);
        boolean pvcDeleted = this.controller.deletePersistentVolumeClaim(pvcName);
        String jobMasterStatefulSetName = KubernetesUtils.createJobMasterStatefulSetName(jobID);
        boolean ssForJobMasterDeleted = this.controller.deleteStatefulSet(jobMasterStatefulSetName);
        String jobMasterServiceName = KubernetesUtils.createJobMasterServiceName(jobID);
        boolean serviceForJobMasterDeleted = this.controller.deleteService(jobMasterServiceName);
        return ssForWorkersDeleted && serviceForWorkersDeleted && serviceForJobMasterDeleted && pvcDeleted && ssForJobMasterDeleted;
    }
}

