/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.rsched.schedulers.k8s.driver;

import edu.iu.dsc.tws.api.config.Config;
import edu.iu.dsc.tws.api.driver.IScalerPerCluster;
import edu.iu.dsc.tws.api.scheduler.SchedulerContext;
import edu.iu.dsc.tws.proto.system.job.JobAPI;
import edu.iu.dsc.tws.rsched.schedulers.k8s.KubernetesController;
import edu.iu.dsc.tws.rsched.schedulers.k8s.KubernetesUtils;
import java.util.logging.Logger;

public class K8sScaler
implements IScalerPerCluster {
    private static final Logger LOG = Logger.getLogger(K8sScaler.class.getName());
    private Config config;
    private KubernetesController k8sController;
    private String scalableSSName;
    private int replicas;
    private int workersPerPod;
    private boolean scalable;

    public K8sScaler(Config config, JobAPI.Job job, KubernetesController k8sController) {
        this.k8sController = k8sController;
        this.config = config;
        int computeResourceIndex = job.getComputeResourceCount() - 1;
        JobAPI.ComputeResource scalableCompRes = job.getComputeResource(computeResourceIndex);
        this.replicas = scalableCompRes.getInstances();
        this.workersPerPod = scalableCompRes.getWorkersPerPod();
        this.scalable = scalableCompRes.getScalable();
        this.scalableSSName = KubernetesUtils.createWorkersStatefulSetName(job.getJobId(), computeResourceIndex);
    }

    public boolean isScalable() {
        if (!this.scalable) {
            return false;
        }
        return !SchedulerContext.useOpenMPI((Config)this.config);
    }

    public boolean scaleUpWorkers(int instancesToAdd) {
        if (instancesToAdd % this.workersPerPod != 0) {
            LOG.severe("instancesToAdd has to be a multiple of workersPerPod=" + this.workersPerPod);
            return false;
        }
        int podsToAdd = instancesToAdd / this.workersPerPod;
        boolean scaledUp = this.k8sController.patchStatefulSet(this.scalableSSName, this.replicas + podsToAdd);
        if (!scaledUp) {
            return false;
        }
        this.replicas += podsToAdd;
        return true;
    }

    public boolean scaleDownWorkers(int instancesToRemove) {
        if (instancesToRemove % this.workersPerPod != 0) {
            LOG.severe("instancesToRemove has to be a multiple of workersPerPod=" + this.workersPerPod);
            return false;
        }
        int podsToRemove = instancesToRemove / this.workersPerPod;
        if (podsToRemove > this.replicas) {
            LOG.severe(String.format("There are %d instances of scalable ComputeResource, and %d instances requested to be removed", this.replicas, podsToRemove));
            return false;
        }
        boolean scaledDown = this.k8sController.patchStatefulSet(this.scalableSSName, this.replicas - podsToRemove);
        if (!scaledDown) {
            return false;
        }
        this.replicas -= podsToRemove;
        return true;
    }
}

