/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.rsched.schedulers.k8s;

import edu.iu.dsc.tws.api.config.Config;
import edu.iu.dsc.tws.proto.system.job.JobAPI;
import edu.iu.dsc.tws.rsched.schedulers.k8s.KubernetesContext;
import edu.iu.dsc.tws.rsched.utils.JobUtils;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class KubernetesUtils {
    private static final Logger LOG = Logger.getLogger(KubernetesUtils.class.getName());

    private KubernetesUtils() {
    }

    public static int indexFromName(String name) {
        return Integer.parseInt(name.substring(name.lastIndexOf("-") + 1));
    }

    public static String removeIndexFromName(String name) {
        return name.substring(0, name.lastIndexOf("-"));
    }

    public static String[] createCopyCommand(String filename, String namespace, String podName, String podFile) {
        String targetDir = String.format("%s/%s:%s", namespace, podName, podFile);
        return new String[]{"kubectl", "cp", filename, targetDir};
    }

    public static String podNameFromStatefulSetName(String ssName, int podIndex) {
        return ssName + "-" + podIndex;
    }

    public static String createServiceName(String jobID) {
        return "t2s-" + jobID;
    }

    public static String createJobMasterServiceName(String jobID) {
        return "t2s-" + jobID + "-jm";
    }

    public static String createPersistentVolumeClaimName(String jobID) {
        return "t2strg-" + jobID;
    }

    public static String createPersistentVolumeName(String jobID) {
        return "persistent-volume-" + jobID;
    }

    public static String createServiceLabel(String jobID) {
        return "t2s-lb-" + jobID;
    }

    public static String createJobMasterServiceLabel(String jobID) {
        return "t2s-lb-" + jobID + "-jm";
    }

    public static String createJobMasterRoleLabel(String jobID) {
        return jobID + "-jm";
    }

    public static String createWorkerRoleLabel(String jobID) {
        return jobID + "-worker";
    }

    public static String createJobPodsLabel(String jobID) {
        return "t2pod-lb-" + jobID;
    }

    public static String createServiceLabelWithKey(String jobID) {
        return "app=" + KubernetesUtils.createServiceLabel(jobID);
    }

    public static String createJobMasterServiceLabelWithKey(String jobID) {
        return "app=" + KubernetesUtils.createJobMasterServiceLabel(jobID);
    }

    public static String createJobPodsLabelWithKey(String jobID) {
        return "twister2-job-pods=" + KubernetesUtils.createJobPodsLabel(jobID);
    }

    public static String createJobMasterRoleLabelWithKey(String jobID) {
        return "twister2-role=" + KubernetesUtils.createJobMasterRoleLabel(jobID);
    }

    public static String createWorkerRoleLabelWithKey(String jobID) {
        return "twister2-role=" + KubernetesUtils.createWorkerRoleLabel(jobID);
    }

    public static String createContainerName(int containerIndex) {
        return "twister2-container-" + containerIndex;
    }

    public static String createWorkersStatefulSetName(String jobID, int index) {
        return jobID + "-" + index;
    }

    public static String createJobMasterStatefulSetName(String jobID) {
        return jobID + "-jm";
    }

    public static String createJobMasterPodName(String jobID) {
        return KubernetesUtils.createJobMasterStatefulSetName(jobID) + "-0";
    }

    public static String jobPackageFullPath(Config config, String jobID) {
        String uploaderDir = KubernetesContext.uploaderWebServerDirectory(config);
        String jobPackageFullPath = uploaderDir + "/" + JobUtils.createJobPackageFileName(jobID);
        return jobPackageFullPath;
    }

    public static String getLocalAddress() {
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            LOG.log(Level.SEVERE, "Exception when getting local host address: ", e);
            return null;
        }
    }

    public static InetAddress convertToIPAddress(String ipStr) {
        try {
            return InetAddress.getByName(ipStr);
        }
        catch (UnknownHostException e) {
            LOG.log(Level.SEVERE, "Exception when converting to IP adress: ", e);
            return null;
        }
    }

    public static int numberOfWorkerPods(JobAPI.Job job) {
        int podsCount = 0;
        for (JobAPI.ComputeResource computeResource : job.getComputeResourceList()) {
            podsCount += computeResource.getInstances();
        }
        return podsCount;
    }

    public static ArrayList<String> generatePodNames(JobAPI.Job job) {
        ArrayList<String> podNames = new ArrayList<String>();
        List resourceList = job.getComputeResourceList();
        for (int i = 0; i < resourceList.size(); ++i) {
            JobAPI.ComputeResource computeResource = (JobAPI.ComputeResource)resourceList.get(i);
            int podsCount = computeResource.getInstances();
            int index = computeResource.getIndex();
            for (int j = 0; j < podsCount; ++j) {
                String ssName = KubernetesUtils.createWorkersStatefulSetName(job.getJobId(), index);
                String podName = KubernetesUtils.podNameFromStatefulSetName(ssName, j);
                podNames.add(podName);
            }
        }
        return podNames;
    }
}

