/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.rsched.schedulers.aurora;

import edu.iu.dsc.tws.rsched.schedulers.aurora.AuroraField;
import edu.iu.dsc.tws.rsched.utils.ProcessUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

class AuroraClientController {
    private static final Logger LOG = Logger.getLogger(AuroraClientController.class.getName());
    private final String jobSpec;
    private final boolean isVerbose;

    AuroraClientController(String cluster, String role, String env, String jobName, boolean isVerbose) {
        this.jobSpec = String.format("%s/%s/%s/%s", cluster, role, env, jobName);
        this.isVerbose = isVerbose;
    }

    public boolean createJob(Map<AuroraField, String> bindings, String auroraFilename) {
        ArrayList<String> auroraCmd = new ArrayList<String>(Arrays.asList("aurora", "job", "create", "--wait-until", "RUNNING"));
        for (AuroraField field : bindings.keySet()) {
            auroraCmd.add("--bind");
            auroraCmd.add(String.format("%s=%s", new Object[]{field, bindings.get((Object)field)}));
        }
        auroraCmd.add(this.jobSpec);
        auroraCmd.add(auroraFilename);
        if (this.isVerbose) {
            auroraCmd.add("--verbose");
        }
        return this.runProcess(auroraCmd);
    }

    public boolean killJob() {
        ArrayList<String> auroraCmd = new ArrayList<String>(Arrays.asList("aurora", "job", "killall"));
        auroraCmd.add(this.jobSpec);
        AuroraClientController.appendAuroraCommandOptions(auroraCmd, this.isVerbose);
        return this.runProcess(auroraCmd);
    }

    public boolean restart(Integer containerId) {
        ArrayList<String> auroraCmd = new ArrayList<String>(Arrays.asList("aurora", "job", "restart"));
        if (containerId != null) {
            auroraCmd.add(String.format("%s/%d", this.jobSpec, containerId));
        } else {
            auroraCmd.add(this.jobSpec);
        }
        AuroraClientController.appendAuroraCommandOptions(auroraCmd, this.isVerbose);
        return this.runProcess(auroraCmd);
    }

    public void addContainers(Integer count) {
        ArrayList<String> auroraCmd = new ArrayList<String>(Arrays.asList("aurora", "job", "add", "--wait-until", "RUNNING", this.jobSpec + "/0", count.toString()));
        if (this.isVerbose) {
            auroraCmd.add("--verbose");
        }
        LOG.info(String.format("Requesting %s new aurora containers %s", count, auroraCmd));
        if (!this.runProcess(auroraCmd)) {
            throw new RuntimeException("Failed to create " + count + " new aurora instances");
        }
    }

    boolean runProcess(List<String> auroraCmd) {
        StringBuilder stdout = new StringBuilder();
        StringBuilder stderr = new StringBuilder();
        int status = ProcessUtils.runSyncProcess(false, auroraCmd.toArray(new String[auroraCmd.size()]), stderr, new File("."), false);
        if (status != 0) {
            LOG.severe(String.format("Failed to run process. Command=%s, STDOUT=%s, STDERR=%s", auroraCmd, stdout, stderr));
        }
        return status == 0;
    }

    private static void appendAuroraCommandOptions(List<String> auroraCmd, boolean isVerbose) {
        if (isVerbose) {
            auroraCmd.add("--verbose");
        }
        auroraCmd.add("--batch-size");
        auroraCmd.add(Integer.toString(Integer.MAX_VALUE));
    }
}

