/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.rsched.bootstrap;

import edu.iu.dsc.tws.api.config.Config;
import edu.iu.dsc.tws.rsched.bootstrap.ZKUtil;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.nodes.PersistentNode;

public class ZKJobMasterRegistrar {
    private static final Logger LOG = Logger.getLogger(ZKJobMasterRegistrar.class.getName());
    private String jobMasterIP;
    private int jobMasterPort;
    private Config config;
    private CuratorFramework client;
    private String jobMasterPath;
    private PersistentNode jobMasterNode;

    public ZKJobMasterRegistrar(Config config, String jobMasterIP, int jobMasterPort) {
        this.config = config;
        this.jobMasterIP = jobMasterIP;
        this.jobMasterPort = jobMasterPort;
        this.jobMasterPath = ZKUtil.constructJobMasterPath(config);
    }

    public boolean initialize() {
        if (this.client == null) {
            this.client = ZKUtil.connectToServer(this.config);
        }
        if (this.sameZNodeExist()) {
            LOG.severe("Same znode exist. Could not initialize JobMasterRegistrar.");
            return false;
        }
        boolean znodeCreated = this.createJobMasterZnode();
        if (znodeCreated) {
            LOG.info("JobMasterRegistrar initialized successfully");
        } else {
            LOG.info("JobMasterRegistrar could not be initialized successfully");
        }
        return znodeCreated;
    }

    public boolean sameZNodeExist() {
        if (this.client == null) {
            ZKUtil.connectToServer(this.config);
        }
        try {
            return this.client.checkExists().forPath(this.jobMasterPath) != null;
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Exception when trying to check the existence of the znode: " + this.jobMasterPath, e);
            return false;
        }
    }

    private boolean createJobMasterZnode() {
        String jobMasterIPandPort = this.jobMasterIP + ":" + this.jobMasterPort;
        try {
            this.jobMasterNode = ZKUtil.createPersistentZnode(this.client, this.jobMasterPath, jobMasterIPandPort.getBytes());
            this.jobMasterNode.start();
            this.jobMasterNode.waitForInitialCreate(10000L, TimeUnit.MILLISECONDS);
            this.jobMasterPath = this.jobMasterNode.getActualPath();
            LOG.info("An ephemeral znode is created for the Job Master: " + this.jobMasterPath);
            return true;
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Could not create znode for the Job Master: " + jobMasterIPandPort, e);
            return false;
        }
    }

    public void deleteJobMasterZNode() {
        if (this.client == null) {
            ZKUtil.connectToServer(this.config);
        }
        try {
            this.client.delete().forPath(this.jobMasterPath);
            LOG.info("Previously existing Znode deleted: " + this.jobMasterPath);
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Exception when deleting the previous Znode: " + this.jobMasterPath, e);
        }
    }

    public void close() {
        if (this.jobMasterNode != null) {
            try {
                this.jobMasterNode.close();
            }
            catch (IOException e) {
                LOG.log(Level.WARNING, "Exception when deleting Job Master Znode: " + this.jobMasterPath, e);
            }
        }
        this.client.close();
    }
}

