/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.api.dataset;

import edu.iu.dsc.tws.api.dataset.DataPartition;
import java.io.Serializable;

public interface DataObject<T>
extends Serializable {
    public void addPartition(DataPartition<T> var1);

    public DataPartition<T>[] getPartitions();

    public DataPartition<T> getPartition(int var1);

    default public DataPartition<T> getAnyPartition() {
        if (this.getPartitionCount() > 0) {
            return this.getPartitions()[0];
        }
        return null;
    }

    default public DataPartition<T> getLowestPartition() {
        if (this.getPartitionCount() > 0) {
            DataPartition<T> lowestPartition = null;
            int lowestId = Integer.MAX_VALUE;
            for (DataPartition<T> partition : this.getPartitions()) {
                if (partition.getPartitionId() >= lowestId) continue;
                lowestId = partition.getPartitionId();
                lowestPartition = partition;
            }
            return lowestPartition;
        }
        return null;
    }

    public int getPartitionCount();

    public String getID();
}

