/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.json;

import com.oracle.labs.mlrg.olcut.config.Config;
import com.oracle.labs.mlrg.olcut.provenance.ObjectProvenance;
import com.oracle.labs.mlrg.olcut.provenance.PrimitiveProvenance;
import com.oracle.labs.mlrg.olcut.provenance.Provenance;
import com.oracle.labs.mlrg.olcut.provenance.ProvenanceUtil;
import com.oracle.labs.mlrg.olcut.provenance.impl.SkeletalConfiguredObjectProvenance;
import com.oracle.labs.mlrg.olcut.provenance.primitives.DateTimeProvenance;
import com.oracle.labs.mlrg.olcut.provenance.primitives.HashProvenance;
import com.oracle.labs.mlrg.olcut.provenance.primitives.StringProvenance;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;
import org.tribuo.Output;
import org.tribuo.data.columnar.ColumnarDataSource;
import org.tribuo.data.columnar.ColumnarIterator;
import org.tribuo.data.columnar.RowProcessor;
import org.tribuo.json.JsonFileIterator;
import org.tribuo.provenance.ConfiguredDataSourceProvenance;

public class JsonDataSource<T extends Output<T>>
extends ColumnarDataSource<T> {
    private static final Logger logger = Logger.getLogger(JsonFileIterator.class.getName());
    private URI dataFile;
    @Config(mandatory=true, description="Path to the json file.")
    private Path dataPath;
    private ConfiguredDataSourceProvenance provenance;

    private JsonDataSource() {
    }

    public JsonDataSource(Path dataPath, RowProcessor<T> rowProcessor, boolean outputRequired) {
        this(dataPath.toUri(), dataPath, rowProcessor, outputRequired);
    }

    public JsonDataSource(URI dataFile, RowProcessor<T> rowProcessor, boolean outputRequired) {
        this(dataFile, Paths.get(dataFile), rowProcessor, outputRequired);
    }

    private JsonDataSource(URI dataFile, Path dataPath, RowProcessor<T> rowProcessor, boolean outputRequired) {
        super(rowProcessor.getResponseProcessor().getOutputFactory(), rowProcessor, outputRequired);
        this.dataPath = dataPath;
        this.dataFile = dataFile;
        this.provenance = new JsonDataSourceProvenance(this);
    }

    public void postConfig() {
        this.dataFile = this.dataPath.toUri();
        this.provenance = new JsonDataSourceProvenance(this);
    }

    public String toString() {
        return "JsonDataSource(file=" + this.dataFile + ",rowProcessor=" + this.rowProcessor.getDescription() + ")";
    }

    public ColumnarIterator rowIterator() {
        try {
            return new JsonFileIterator(this.dataFile);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to read data", e);
        }
    }

    public ConfiguredDataSourceProvenance getProvenance() {
        return this.provenance;
    }

    public static class JsonDataSourceProvenance
    extends SkeletalConfiguredObjectProvenance
    implements ConfiguredDataSourceProvenance {
        private static final long serialVersionUID = 1L;
        private final DateTimeProvenance fileModifiedTime;
        private final DateTimeProvenance dataSourceCreationTime;
        private final HashProvenance sha256Hash;

        <T extends Output<T>> JsonDataSourceProvenance(JsonDataSource<T> host) {
            super(host, "DataSource");
            this.fileModifiedTime = new DateTimeProvenance("file-modified-time", OffsetDateTime.ofInstant(Instant.ofEpochMilli(((JsonDataSource)host).dataPath.toFile().lastModified()), ZoneId.systemDefault()));
            this.dataSourceCreationTime = new DateTimeProvenance("datasource-creation-time", OffsetDateTime.now());
            this.sha256Hash = new HashProvenance(DEFAULT_HASH_TYPE, "resource-hash", ProvenanceUtil.hashResource((ProvenanceUtil.HashType)DEFAULT_HASH_TYPE, (Path)((JsonDataSource)host).dataPath));
        }

        public JsonDataSourceProvenance(Map<String, Provenance> map) {
            this(JsonDataSourceProvenance.extractProvenanceInfo(map));
        }

        private JsonDataSourceProvenance(SkeletalConfiguredObjectProvenance.ExtractedInfo info) {
            super(info);
            this.fileModifiedTime = (DateTimeProvenance)info.instanceValues.get("file-modified-time");
            this.dataSourceCreationTime = (DateTimeProvenance)info.instanceValues.get("datasource-creation-time");
            this.sha256Hash = (HashProvenance)info.instanceValues.get("resource-hash");
        }

        protected static SkeletalConfiguredObjectProvenance.ExtractedInfo extractProvenanceInfo(Map<String, Provenance> map) {
            HashMap<String, Provenance> configuredParameters = new HashMap<String, Provenance>(map);
            String className = ((StringProvenance)ObjectProvenance.checkAndExtractProvenance(configuredParameters, (String)"class-name", StringProvenance.class, (String)JsonDataSourceProvenance.class.getSimpleName())).getValue();
            String hostTypeStringName = ((StringProvenance)ObjectProvenance.checkAndExtractProvenance(configuredParameters, (String)"host-short-name", StringProvenance.class, (String)JsonDataSourceProvenance.class.getSimpleName())).getValue();
            HashMap<String, PrimitiveProvenance> instanceParameters = new HashMap<String, PrimitiveProvenance>();
            instanceParameters.put("file-modified-time", (PrimitiveProvenance)ObjectProvenance.checkAndExtractProvenance(configuredParameters, (String)"file-modified-time", DateTimeProvenance.class, (String)JsonDataSourceProvenance.class.getSimpleName()));
            instanceParameters.put("datasource-creation-time", (PrimitiveProvenance)ObjectProvenance.checkAndExtractProvenance(configuredParameters, (String)"datasource-creation-time", DateTimeProvenance.class, (String)JsonDataSourceProvenance.class.getSimpleName()));
            instanceParameters.put("resource-hash", (PrimitiveProvenance)ObjectProvenance.checkAndExtractProvenance(configuredParameters, (String)"resource-hash", HashProvenance.class, (String)JsonDataSourceProvenance.class.getSimpleName()));
            return new SkeletalConfiguredObjectProvenance.ExtractedInfo(className, hostTypeStringName, configuredParameters, instanceParameters);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            JsonDataSourceProvenance pairs = (JsonDataSourceProvenance)((Object)o);
            return this.fileModifiedTime.equals((Object)pairs.fileModifiedTime) && this.dataSourceCreationTime.equals((Object)pairs.dataSourceCreationTime) && this.sha256Hash.equals((Object)pairs.sha256Hash);
        }

        public int hashCode() {
            return Objects.hash(super.hashCode(), this.fileModifiedTime, this.dataSourceCreationTime, this.sha256Hash);
        }

        public Map<String, PrimitiveProvenance<?>> getInstanceValues() {
            Map map = super.getInstanceValues();
            map.put("file-modified-time", this.fileModifiedTime);
            map.put("datasource-creation-time", this.dataSourceCreationTime);
            map.put("resource-hash", this.sha256Hash);
            return map;
        }
    }
}

