/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.swizzle.stream;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.util.function.Consumer;
import org.tomitribe.swizzle.stream.DelimitedTokenReplacementInputStream;
import org.tomitribe.swizzle.stream.DelimitedTokenWatchInputStream;
import org.tomitribe.swizzle.stream.ExcludeFilterInputStream;
import org.tomitribe.swizzle.stream.FixedTokenReplacementInputStream;
import org.tomitribe.swizzle.stream.FixedTokenWatchInputStream;
import org.tomitribe.swizzle.stream.IOConsumer;
import org.tomitribe.swizzle.stream.IOFunction;
import org.tomitribe.swizzle.stream.IncludeFilterInputStream;
import org.tomitribe.swizzle.stream.StringHandler;

public class StreamBuilder {
    private InputStream in;

    public StreamBuilder(InputStream in) {
        this.in = in;
    }

    public StreamBuilder include(String begin, String end) {
        return this.include(begin, end, true);
    }

    public StreamBuilder include(String begin, String end, boolean caseSensitive) {
        return this.include(begin, end, caseSensitive, true);
    }

    public StreamBuilder include(String begin, String end, boolean caseSensitive, boolean retainDelimiters) {
        this.in = new IncludeFilterInputStream(this.in, begin, end, caseSensitive, retainDelimiters);
        return this;
    }

    public StreamBuilder exclude(String begin, String end) {
        return this.exclude(begin, end, false, true);
    }

    public StreamBuilder exclude(String begin, String end, boolean caseSensitive) {
        return this.exclude(begin, end, caseSensitive, false);
    }

    public StreamBuilder exclude(String begin, String end, boolean caseSensitive, boolean retainDelimiters) {
        this.in = new ExcludeFilterInputStream(this.in, begin, end, caseSensitive, retainDelimiters);
        return this;
    }

    public StreamBuilder delete(String token) {
        return this.replace(token, "");
    }

    public StreamBuilder delete(String begin, String end) {
        return this.replace(begin, end, "");
    }

    public StreamBuilder deleteBetween(String begin, String end) {
        return this.replaceBetween(begin, end, "");
    }

    public StreamBuilder replace(String token, String with) {
        return this.replace(token, s -> with);
    }

    public StreamBuilder replace(String token, StringHandler with) {
        this.in = new FixedTokenReplacementInputStream(this.in, token, with);
        return this;
    }

    public StreamBuilder replace(String begin, String end, StringHandler handler) {
        this.in = new DelimitedTokenReplacementInputStream(this.in, begin, end, handler);
        return this;
    }

    public StreamBuilder replace(String begin, String end, String with) {
        return this.replace(begin, end, s -> with);
    }

    public StreamBuilder replaceBetween(String begin, String end, StringHandler handler) {
        StringHandler includeDelimiters = s -> begin + (String)handler.apply(s) + end;
        this.in = new DelimitedTokenReplacementInputStream(this.in, begin, end, includeDelimiters);
        return this;
    }

    public StreamBuilder replaceBetween(String begin, String end, String with) {
        return this.replaceBetween(begin, end, s -> with);
    }

    public static StreamBuilder create(InputStream in) {
        return new StreamBuilder(in);
    }

    public static StreamBuilder of(InputStream in) {
        return new StreamBuilder(in);
    }

    public static StreamBuilder of(File file) {
        try {
            FileInputStream in = new FileInputStream(file);
            return new StreamBuilder(new BufferedInputStream(in, 32768));
        }
        catch (FileNotFoundException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static StreamBuilder of(byte[] bytes) {
        return new StreamBuilder(new ByteArrayInputStream(bytes));
    }

    public static StreamBuilder of(String contents) {
        return new StreamBuilder(new ByteArrayInputStream(contents.getBytes()));
    }

    public static StreamBuilder of(String contents, Charset charset) {
        return new StreamBuilder(new ByteArrayInputStream(contents.getBytes(charset)));
    }

    public StreamBuilder watch(OutputStream consumer) {
        this.in = new WatchAllInputStream(this.in, consumer);
        return this;
    }

    public StreamBuilder watch(String token, Consumer<String> consumer) {
        this.in = new FixedTokenWatchInputStream(this.in, token, consumer);
        return this;
    }

    public StreamBuilder watch(String token, boolean caseSensitive, Consumer<String> consumer) {
        this.in = new FixedTokenWatchInputStream(this.in, token, caseSensitive, consumer);
        return this;
    }

    public StreamBuilder watch(String begin, String end, Consumer<String> consumer) {
        this.in = new DelimitedTokenWatchInputStream(this.in, begin, end, consumer);
        return this;
    }

    public StreamBuilder watch(String begin, String end, boolean caseSensitive, boolean includeDelimiters, Consumer<String> consumer) {
        this.in = new DelimitedTokenWatchInputStream(this.in, begin, end, caseSensitive, includeDelimiters, consumer);
        return this;
    }

    public StreamBuilder watch(String token, Runnable runnable) {
        this.in = new FixedTokenWatchInputStream(this.in, token, runnable);
        return this;
    }

    public StreamBuilder watch(String token, boolean caseSensitive, Runnable runnable) {
        this.in = new FixedTokenWatchInputStream(this.in, token, caseSensitive, runnable);
        return this;
    }

    public StreamBuilder watch(String begin, String end, Runnable runnable) {
        this.in = new DelimitedTokenWatchInputStream(this.in, begin, end, runnable);
        return this;
    }

    public StreamBuilder watch(String begin, String end, boolean caseSensitive, boolean includeDelimiters, Runnable runnable) {
        this.in = new DelimitedTokenWatchInputStream(this.in, begin, end, caseSensitive, includeDelimiters, runnable);
        return this;
    }

    public StreamBuilder substream(String begin, String end, IOFunction<InputStream, InputStream> decorator) {
        this.in = StreamBuilder.substream(this.in, begin, end, decorator);
        return this;
    }

    public static InputStream substream(InputStream in, String begin, String end, IOFunction<InputStream, InputStream> decorator) {
        return new DelimitedTokenReplacementInputStream(in, begin, end, s -> (InputStream)decorator.apply(new ByteArrayInputStream(s.getBytes())));
    }

    public void to(OutputStream out) throws IOException {
        StreamBuilder.copy(this.in, out);
    }

    public void run() throws IOException {
        this.to(new OutputStream(){

            @Override
            public void write(int b) throws IOException {
            }
        });
    }

    public <R> R consume(IOFunction<InputStream, R> ioFunction) {
        try {
            R r = ioFunction.apply(this.in);
            return r;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            try {
                this.in.close();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    public void consume(IOConsumer<InputStream> consumer) {
        try {
            consumer.accept(this.in);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            try {
                this.in.close();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    public InputStream get() {
        return this.in;
    }

    private static void copy(InputStream from, OutputStream to) throws IOException {
        int length;
        byte[] buffer = new byte[1024];
        while ((length = from.read(buffer)) != -1) {
            to.write(buffer, 0, length);
        }
        to.flush();
    }

    private static class WatchAllInputStream
    extends InputStream {
        private final InputStream in;
        private final OutputStream consumer;

        public WatchAllInputStream(InputStream in, OutputStream consumer) {
            this.in = in;
            this.consumer = consumer;
        }

        @Override
        public int read() throws IOException {
            int read = this.in.read();
            this.consumer.write(read);
            return read;
        }
    }
}

