/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.swizzle.stream;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.function.Consumer;
import java.util.function.Function;
import org.tomitribe.swizzle.stream.DelimitedTokenReplacementInputStream;
import org.tomitribe.swizzle.stream.DelimitedTokenWatchInputStream;
import org.tomitribe.swizzle.stream.ExcludeFilterInputStream;
import org.tomitribe.swizzle.stream.FixedTokenWatchInputStream;
import org.tomitribe.swizzle.stream.IncludeFilterInputStream;
import org.tomitribe.swizzle.stream.ReplaceStringInputStream;

public class StreamBuilder {
    private InputStream in;

    public StreamBuilder(InputStream in) {
        this.in = in;
    }

    public StreamBuilder include(String begin, String end) {
        return this.include(begin, end, true);
    }

    public StreamBuilder include(String begin, String end, boolean caseSensitive) {
        return this.include(begin, end, caseSensitive, true);
    }

    public StreamBuilder include(String begin, String end, boolean caseSensitive, boolean retainDelimiters) {
        this.in = new IncludeFilterInputStream(this.in, begin, end, caseSensitive, retainDelimiters);
        return this;
    }

    public StreamBuilder exclude(String begin, String end) {
        return this.exclude(begin, end, false, true);
    }

    public StreamBuilder exclude(String begin, String end, boolean caseSensitive) {
        return this.exclude(begin, end, caseSensitive, false);
    }

    public StreamBuilder exclude(String begin, String end, boolean caseSensitive, boolean retainDelimiters) {
        this.in = new ExcludeFilterInputStream(this.in, begin, end, caseSensitive, retainDelimiters);
        return this;
    }

    public StreamBuilder delete(String token) {
        this.in = new ReplaceStringInputStream(this.in, token, "");
        return this;
    }

    public StreamBuilder deleteBetween(String begin, String end, boolean caseSensitive) {
        return this.exclude(begin, end, caseSensitive, false);
    }

    public StreamBuilder deleteBetween(String begin, String end) {
        this.in = new ExcludeFilterInputStream(this.in, begin, end, true, true);
        return this;
    }

    public StreamBuilder replace(String token, String with) {
        this.in = new ReplaceStringInputStream(this.in, token, with);
        return this;
    }

    public static StreamBuilder create(InputStream in) {
        return new StreamBuilder(in);
    }

    public StreamBuilder watch(OutputStream consumer) {
        this.in = new WatchAllInputStream(this.in, consumer);
        return this;
    }

    public StreamBuilder watch(String token, Consumer<String> consumer) {
        this.in = new FixedTokenWatchInputStream(this.in, token, consumer);
        return this;
    }

    public StreamBuilder watch(String token, boolean caseSensitive, Consumer<String> consumer) {
        this.in = new FixedTokenWatchInputStream(this.in, token, caseSensitive, consumer);
        return this;
    }

    public StreamBuilder watch(String begin, String end, Consumer<String> consumer) {
        this.in = new DelimitedTokenWatchInputStream(this.in, begin, end, consumer);
        return this;
    }

    public StreamBuilder watch(String begin, String end, boolean caseSensitive, boolean includeDelimiters, Consumer<String> consumer) {
        this.in = new DelimitedTokenWatchInputStream(this.in, begin, end, caseSensitive, includeDelimiters, consumer);
        return this;
    }

    public StreamBuilder watch(String token, Runnable runnable) {
        this.in = new FixedTokenWatchInputStream(this.in, token, runnable);
        return this;
    }

    public StreamBuilder watch(String token, boolean caseSensitive, Runnable runnable) {
        this.in = new FixedTokenWatchInputStream(this.in, token, caseSensitive, runnable);
        return this;
    }

    public StreamBuilder watch(String begin, String end, Runnable runnable) {
        this.in = new DelimitedTokenWatchInputStream(this.in, begin, end, runnable);
        return this;
    }

    public StreamBuilder watch(String begin, String end, boolean caseSensitive, boolean includeDelimiters, Runnable runnable) {
        this.in = new DelimitedTokenWatchInputStream(this.in, begin, end, caseSensitive, includeDelimiters, runnable);
        return this;
    }

    public StreamBuilder substream(String begin, String end, Function<InputStream, InputStream> decorator) {
        this.in = StreamBuilder.substream(this.in, begin, end, decorator);
        return this;
    }

    public static InputStream substream(InputStream in, String begin, String end, Function<InputStream, InputStream> decorator) {
        return new DelimitedTokenReplacementInputStream(in, begin, end, s -> (InputStream)decorator.apply(new ByteArrayInputStream(s.getBytes())));
    }

    public void to(OutputStream out) throws IOException {
        StreamBuilder.copy(this.in, out);
    }

    public void run() throws IOException {
        this.to(new OutputStream(){

            @Override
            public void write(int b) throws IOException {
            }
        });
    }

    public InputStream get() {
        return this.in;
    }

    private static void copy(InputStream from, OutputStream to) throws IOException {
        int length;
        byte[] buffer = new byte[1024];
        while ((length = from.read(buffer)) != -1) {
            to.write(buffer, 0, length);
        }
        to.flush();
    }

    private static class WatchAllInputStream
    extends InputStream {
        private final InputStream in;
        private final OutputStream consumer;

        public WatchAllInputStream(InputStream in, OutputStream consumer) {
            this.in = in;
            this.consumer = consumer;
        }

        @Override
        public int read() throws IOException {
            int read = this.in.read();
            this.consumer.write(read);
            return read;
        }
    }
}

