/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.swizzle.stream;

public class ScanBuffer {
    private char[] buffer = new char[0];
    private int[] buffer2 = new int[0];
    private char[] token = new char[0];
    private int pos;
    boolean cs;

    public ScanBuffer(String scanString) {
        this(scanString, false);
    }

    public ScanBuffer(int size) {
        this.buffer = new char[size];
        this.buffer2 = new int[size];
        this.token = new char[size];
        this.flush();
        this.cs = true;
    }

    public ScanBuffer(String scanString, boolean caseSensitive) {
        this(scanString.length());
        this.setScanString(scanString, caseSensitive);
    }

    public int size() {
        return this.buffer.length;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "#" + this.getScanString() + " # buffer[" + new String(this.getBuffer()) + "]";
    }

    public void resetPosition() {
        this.pos = 0;
    }

    public String getScanString() {
        return new String(this.token);
    }

    public void setScanString(String stringToken) {
        this.setScanString(stringToken, true);
    }

    public void setScanString(String stringToken, boolean caseSensitive) {
        this.cs = caseSensitive;
        this.token = new char[stringToken.length()];
        stringToken.getChars(0, this.token.length, this.token, 0);
        if (this.token.length > this.buffer.length) {
            this.buffer = new char[this.token.length * 4];
            this.buffer2 = new int[this.token.length * 4];
        }
        this.pos = 0;
        if (!this.cs) {
            for (int i = 0; i < this.token.length; ++i) {
                this.token[i] = Character.toLowerCase(this.token[i]);
            }
        }
        this.flush();
    }

    public int append(int newByte) {
        if (this.token.length == 0) {
            return newByte;
        }
        int old = this.buffer2[this.pos];
        this.buffer2[this.pos] = newByte;
        this.buffer[this.pos] = this.cs ? (char)newByte : Character.toLowerCase((char)newByte);
        this.pos = ++this.pos < this.buffer.length ? this.pos : 0;
        return old;
    }

    public void flush() {
        int NULL = 65535;
        for (int i = 0; i < this.buffer.length; ++i) {
            this.buffer[i] = NULL;
            this.buffer2[i] = -1;
        }
        this.resetPosition();
    }

    public boolean match() {
        int rpos;
        int apos = this.token.length - 1;
        for (rpos = this.pos - 1; rpos > -1 && apos > -1; --rpos, --apos) {
            if (this.buffer[rpos] == this.token[apos]) continue;
            return false;
        }
        rpos = this.buffer.length - 1;
        while (apos > -1) {
            if (this.buffer[rpos] != this.token[apos]) {
                return false;
            }
            --rpos;
            --apos;
        }
        return true;
    }

    public boolean hasData() {
        int rpos;
        int apos = this.token.length - 1;
        for (rpos = this.pos - 1; rpos > -1 && apos > -1; --rpos, --apos) {
            if (this.buffer2[rpos] == -1) continue;
            return true;
        }
        rpos = this.buffer2.length - 1;
        while (apos > -1) {
            if (this.buffer2[rpos] != -1) {
                return true;
            }
            --rpos;
            --apos;
        }
        return false;
    }

    private void log(String str) {
        System.out.println("[Scan] " + str);
    }

    public void clear(int i) {
        int rpos;
        int NULL = 65535;
        int apos = i - 1;
        for (rpos = this.pos - 1; rpos > -1 && apos > -1; --rpos, --apos) {
            this.buffer[rpos] = NULL;
            this.buffer2[rpos] = -1;
        }
        rpos = this.buffer.length - 1;
        while (apos > -1) {
            this.buffer[rpos] = NULL;
            this.buffer2[rpos] = -1;
            --rpos;
            --apos;
        }
    }

    public byte[] getBuffer() {
        byte[] out = new byte[this.getSize()];
        for (int i = 0; i < out.length; ++i) {
            out[i] = (byte)this.getByte(this.buffer.length - out.length + i);
        }
        return out;
    }

    private int getSize() {
        int b;
        int size = 0;
        for (int i = this.buffer.length - 1; i >= 0 && (b = this.getByte(i)) != -1; --i) {
            ++size;
        }
        return size;
    }

    private int getByte(int absolutePosition) {
        if (absolutePosition >= this.buffer.length) {
            throw new IndexOutOfBoundsException();
        }
        int realPosition = (this.pos + absolutePosition) % this.buffer.length;
        return this.buffer2[realPosition];
    }
}

