/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.swizzle.stream;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.tomitribe.swizzle.stream.FilteredInputStream;
import org.tomitribe.swizzle.stream.ScanBuffer;
import org.tomitribe.swizzle.stream.StreamTokenHandler;

public class DelimitedTokenReplacementInputStream
extends FilteredInputStream {
    private final ScanBuffer beginBuffer;
    private final ScanBuffer endBuffer;
    private InputStream value;
    private final StreamTokenHandler handler;
    private StreamReadingStrategy strategy;
    private final StreamReadingStrategy readingToken = new StreamReadingStrategy(){

        @Override
        public int _read() throws IOException {
            DelimitedTokenReplacementInputStream.this.endBuffer.flush();
            StringBuffer token = new StringBuffer();
            while (true) {
                int stream = DelimitedTokenReplacementInputStream.this.superRead();
                int buffer = DelimitedTokenReplacementInputStream.this.endBuffer.append(stream);
                char s = (char)stream;
                char b = (char)buffer;
                if (buffer == -1 && stream != -1) continue;
                if (buffer == -1 && stream == -1) {
                    token.insert(0, DelimitedTokenReplacementInputStream.this.beginBuffer.getScanString());
                    DelimitedTokenReplacementInputStream.this.value = new ByteArrayInputStream(token.toString().getBytes());
                    DelimitedTokenReplacementInputStream.this.endBuffer.resetPosition();
                    DelimitedTokenReplacementInputStream.this.strategy = DelimitedTokenReplacementInputStream.this.flushingValue;
                    return DelimitedTokenReplacementInputStream.this.strategy._read();
                }
                token.append((char)buffer);
                if (DelimitedTokenReplacementInputStream.this.endBuffer.match()) break;
            }
            DelimitedTokenReplacementInputStream.this.value = DelimitedTokenReplacementInputStream.this.handler.processToken(token.toString());
            DelimitedTokenReplacementInputStream.this.strategy = DelimitedTokenReplacementInputStream.this.flushingValue;
            return DelimitedTokenReplacementInputStream.this.strategy._read();
        }
    };
    private final StreamReadingStrategy flushingValue = new StreamReadingStrategy(){

        @Override
        public int _read() throws IOException {
            if (DelimitedTokenReplacementInputStream.this.value == null) {
                return -1;
            }
            int i = DelimitedTokenReplacementInputStream.this.value.read();
            if (i == -1) {
                DelimitedTokenReplacementInputStream.this.strategy = DelimitedTokenReplacementInputStream.this.lookingForToken;
                i = DelimitedTokenReplacementInputStream.this.strategy._read();
            }
            return i;
        }
    };
    private final StreamReadingStrategy lookingForToken = new StreamReadingStrategy(){

        @Override
        public int _read() throws IOException {
            if (DelimitedTokenReplacementInputStream.this.beginBuffer.size() == 0) {
                DelimitedTokenReplacementInputStream.this.strategy = DelimitedTokenReplacementInputStream.this.readingToken;
                return DelimitedTokenReplacementInputStream.this.strategy._read();
            }
            int stream = DelimitedTokenReplacementInputStream.this.superRead();
            int buffer = DelimitedTokenReplacementInputStream.this.beginBuffer.append(stream);
            if (DelimitedTokenReplacementInputStream.this.beginBuffer.match()) {
                DelimitedTokenReplacementInputStream.this.beginBuffer.flush();
                DelimitedTokenReplacementInputStream.this.strategy = DelimitedTokenReplacementInputStream.this.readingToken;
                return buffer == -1 && stream != -1 ? DelimitedTokenReplacementInputStream.this.read() : buffer;
            }
            return buffer == -1 && (stream != -1 || DelimitedTokenReplacementInputStream.this.beginBuffer.hasData()) ? this._read() : buffer;
        }
    };

    public DelimitedTokenReplacementInputStream(InputStream in, String begin, String end, StreamTokenHandler tokenHandler) {
        this(in, begin, end, tokenHandler, true);
    }

    public DelimitedTokenReplacementInputStream(InputStream in, String begin, String end, StreamTokenHandler tokenHandler, boolean caseSensitive) {
        super(in);
        this.handler = tokenHandler;
        this.beginBuffer = new ScanBuffer(begin, caseSensitive);
        this.endBuffer = new ScanBuffer(end, caseSensitive);
        this.strategy = this.lookingForToken;
    }

    @Override
    public int read() throws IOException {
        return this.strategy._read();
    }

    private int superRead() throws IOException {
        return super.read();
    }

    static interface StreamReadingStrategy {
        public int _read() throws IOException;
    }
}

